/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.BlockService;
import com.bloxbean.cardano.client.backend.model.Block;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.List;
import rest.koios.client.backend.api.block.model.BlockInfo;
import rest.koios.client.backend.factory.options.Limit;
import rest.koios.client.backend.factory.options.Option;
import rest.koios.client.backend.factory.options.Options;
import rest.koios.client.backend.factory.options.filters.Filter;
import rest.koios.client.backend.factory.options.filters.FilterType;

public class KoiosBlockService
implements BlockService {
    private final rest.koios.client.backend.api.block.BlockService blockService;

    public KoiosBlockService(rest.koios.client.backend.api.block.BlockService blockService) {
        this.blockService = blockService;
    }

    public Result<Block> getLatestBlock() throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result blockList = this.blockService.getBlockList(Options.builder().option((Option)Limit.of((long)2L)).build());
            if (!blockList.isSuccessful()) {
                return Result.error((String)blockList.getResponse()).code(blockList.getCode());
            }
            return this.convertToBlock((List)blockList.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<Block> getBlockByHash(String blockHash) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result blockInfo = this.blockService.getBlockInformation(blockHash);
            if (!blockInfo.isSuccessful()) {
                return Result.error((String)blockInfo.getResponse()).code(blockInfo.getCode());
            }
            return this.convertToBlock((BlockInfo)blockInfo.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ParseException e) {
            return Result.error((String)"Failed to Parse System Start Date").code(500);
        }
    }

    private Result<Block> convertToBlock(List<rest.koios.client.backend.api.block.model.Block> blocks) {
        Block block = new Block();
        block.setTime(blocks.get(0).getBlockTime().longValue());
        block.setHeight((long)blocks.get(0).getBlockHeight().intValue());
        block.setHash(blocks.get(0).getHash());
        block.setSlot((long)blocks.get(0).getAbsSlot().intValue());
        block.setEpoch(blocks.get(0).getEpochNo());
        block.setEpochSlot(blocks.get(0).getEpochSlot());
        block.setSlotLeader(blocks.get(0).getPool());
        block.setSize(blocks.get(0).getBlockSize());
        block.setTxCount(blocks.get(0).getTxCount());
        block.setBlockVrf(blocks.get(0).getVrfKey());
        block.setPreviousBlock(blocks.get(1).getHash());
        return Result.success((String)"OK").withValue((Object)block).code(200);
    }

    private Result<Block> convertToBlock(BlockInfo blockInfo) throws ParseException {
        Block block = new Block();
        block.setTime(blockInfo.getBlockTime().longValue());
        block.setHeight((long)blockInfo.getBlockHeight().intValue());
        block.setHash(blockInfo.getHash());
        block.setSlot((long)blockInfo.getAbsSlot().intValue());
        block.setEpoch(blockInfo.getEpochNo());
        block.setEpochSlot(blockInfo.getEpochSlot());
        block.setSlotLeader(blockInfo.getPool());
        block.setSize(blockInfo.getBlockSize());
        block.setTxCount(blockInfo.getTxCount());
        block.setOutput(blockInfo.getTotalOutput());
        block.setFees(blockInfo.getTotalFees());
        block.setBlockVrf(blockInfo.getVrfKey());
        block.setPreviousBlock(blockInfo.getParentHash());
        block.setNextBlock(blockInfo.getChildHash());
        block.setConfirmations(blockInfo.getNumConfirmations());
        return Result.success((String)"OK").withValue((Object)block).code(200);
    }

    public Result<Block> getBlockByNumber(BigInteger blockNumber) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result blockList = this.blockService.getBlockList(Options.builder().option((Option)Filter.of((String)"block_height", (FilterType)FilterType.EQ, (String)blockNumber.toString())).build());
            if (!blockList.isSuccessful()) {
                return Result.error((String)blockList.getResponse()).code(blockList.getCode());
            }
            return this.getBlockByHash(((rest.koios.client.backend.api.block.model.Block)((List)blockList.getValue()).get(0)).getHash());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

