/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.ProtocolParams;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.model.EpochContent;
import java.math.BigDecimal;
import rest.koios.client.backend.api.epoch.EpochService;
import rest.koios.client.backend.api.epoch.model.EpochInfo;
import rest.koios.client.backend.api.epoch.model.EpochParams;

public class KoiosEpochService
implements com.bloxbean.cardano.client.backend.api.EpochService {
    private final EpochService epochService;

    public KoiosEpochService(EpochService epochService) {
        this.epochService = epochService;
    }

    public Result<EpochContent> getLatestEpoch() throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result epochInformationResult = this.epochService.getLatestEpochInfo();
            if (!epochInformationResult.isSuccessful()) {
                return Result.error((String)epochInformationResult.getResponse()).code(epochInformationResult.getCode());
            }
            return this.convertToEpochContent((EpochInfo)epochInformationResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<EpochContent> getEpoch(Integer epoch) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result epochInformationResult = this.epochService.getEpochInformationByEpoch(epoch);
            if (!epochInformationResult.isSuccessful()) {
                return Result.error((String)epochInformationResult.getResponse()).code(epochInformationResult.getCode());
            }
            return this.convertToEpochContent((EpochInfo)epochInformationResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<ProtocolParams> getProtocolParameters(Integer epoch) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result epochParametersResult = this.epochService.getEpochParametersByEpoch(epoch);
            if (!epochParametersResult.isSuccessful()) {
                return Result.error((String)epochParametersResult.getResponse()).code(epochParametersResult.getCode());
            }
            return this.convertToProtocolParams((EpochParams)epochParametersResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<ProtocolParams> getProtocolParameters() throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result epochParametersResult = this.epochService.getLatestEpochParameters();
            if (!epochParametersResult.isSuccessful()) {
                return Result.error((String)epochParametersResult.getResponse()).code(epochParametersResult.getCode());
            }
            return this.convertToProtocolParams((EpochParams)epochParametersResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Result<EpochContent> convertToEpochContent(EpochInfo epochInfo) {
        EpochContent epochContent = new EpochContent();
        epochContent.setEpoch(epochInfo.getEpochNo());
        epochContent.setStartTime(epochInfo.getStartTime().longValue());
        epochContent.setEndTime(epochInfo.getEndTime().longValue());
        epochContent.setFirstBlockTime(epochInfo.getFirstBlockTime().longValue());
        epochContent.setLastBlockTime(epochInfo.getLastBlockTime().longValue());
        epochContent.setBlockCount(epochInfo.getBlkCount());
        epochContent.setTxCount(epochInfo.getTxCount());
        epochContent.setOutput(epochInfo.getOutSum());
        epochContent.setFees(epochInfo.getFees());
        epochContent.setActiveStake(epochInfo.getActiveStake());
        return Result.success((String)"OK").withValue((Object)epochContent).code(200);
    }

    private Result<ProtocolParams> convertToProtocolParams(EpochParams epochParams) {
        ProtocolParams protocolParams = new ProtocolParams();
        protocolParams.setMinFeeA(epochParams.getMinFeeA());
        protocolParams.setMinFeeB(epochParams.getMinFeeB());
        protocolParams.setMaxBlockSize(epochParams.getMaxBlockSize());
        protocolParams.setMaxTxSize(epochParams.getMaxTxSize());
        protocolParams.setMaxBlockHeaderSize(epochParams.getMaxBhSize());
        protocolParams.setKeyDeposit(epochParams.getKeyDeposit());
        protocolParams.setPoolDeposit(epochParams.getPoolDeposit());
        protocolParams.setEMax(epochParams.getMaxEpoch());
        protocolParams.setNOpt(epochParams.getOptimalPoolCount());
        protocolParams.setA0(epochParams.getInfluence());
        protocolParams.setRho(epochParams.getMonetaryExpandRate());
        protocolParams.setTau(epochParams.getTreasuryGrowthRate());
        protocolParams.setDecentralisationParam(epochParams.getDecentralisation());
        protocolParams.setExtraEntropy(epochParams.getExtraEntropy());
        protocolParams.setProtocolMajorVer(epochParams.getProtocolMajor());
        protocolParams.setProtocolMinorVer(epochParams.getProtocolMinor());
        protocolParams.setMinUtxo(epochParams.getMinUtxoValue());
        protocolParams.setMinPoolCost(epochParams.getMinPoolCost());
        protocolParams.setNonce(epochParams.getNonce());
        if (epochParams.getPriceMem() != null) {
            protocolParams.setPriceMem(epochParams.getPriceMem());
        }
        if (epochParams.getPriceStep() != null) {
            protocolParams.setPriceStep(epochParams.getPriceStep());
        }
        if (epochParams.getMaxTxExMem() != null) {
            protocolParams.setMaxTxExMem(epochParams.getMaxTxExMem());
        }
        if (epochParams.getMaxTxExSteps() != null) {
            protocolParams.setMaxTxExSteps(epochParams.getMaxTxExSteps());
        }
        if (epochParams.getMaxBlockExMem() != null) {
            protocolParams.setMaxBlockExMem(epochParams.getMaxBlockExMem());
        }
        if (epochParams.getMaxBlockExSteps() != null) {
            protocolParams.setMaxBlockExSteps(epochParams.getMaxBlockExSteps());
        }
        if (epochParams.getMaxValSize() != null) {
            protocolParams.setMaxValSize(epochParams.getMaxValSize());
        }
        if (epochParams.getCollateralPercent() != null) {
            protocolParams.setCollateralPercent(BigDecimal.valueOf(epochParams.getCollateralPercent().intValue()));
        }
        if (epochParams.getMaxCollateralInputs() != null) {
            protocolParams.setMaxCollateralInputs(epochParams.getMaxCollateralInputs());
        }
        if (epochParams.getCostModels() != null) {
            protocolParams.setCostModels(epochParams.getCostModels());
        }
        if (epochParams.getCoinsPerUtxoWord() != null) {
            protocolParams.setCoinsPerUtxoWord(epochParams.getCoinsPerUtxoWord());
        }
        if (epochParams.getCoinsPerUtxoSize() != null) {
            protocolParams.setCoinsPerUtxoSize(epochParams.getCoinsPerUtxoSize());
        }
        return Result.success((String)"OK").withValue((Object)protocolParams).code(200);
    }
}

