/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.MetadataService;
import com.bloxbean.cardano.client.backend.model.metadata.MetadataCBORContent;
import com.bloxbean.cardano.client.backend.model.metadata.MetadataJSONContent;
import com.bloxbean.cardano.client.backend.model.metadata.MetadataLabel;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rest.koios.client.backend.api.transactions.TransactionsService;
import rest.koios.client.backend.api.transactions.model.TxMetadata;
import rest.koios.client.backend.api.transactions.model.TxMetadataLabels;
import rest.koios.client.backend.factory.options.Limit;
import rest.koios.client.backend.factory.options.Offset;
import rest.koios.client.backend.factory.options.Option;
import rest.koios.client.backend.factory.options.Options;
import rest.koios.client.backend.factory.options.Order;
import rest.koios.client.backend.factory.options.SortType;

public class KoiosMetadataService
implements MetadataService {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final TransactionsService transactionsService;

    public KoiosMetadataService(TransactionsService transactionsService) {
        this.transactionsService = transactionsService;
    }

    public Result<List<MetadataJSONContent>> getJSONMetadataByTxnHash(String txnHash) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result txnMetadataList = this.transactionsService.getTransactionMetadata(List.of(txnHash), null);
            if (!txnMetadataList.isSuccessful()) {
                return Result.error((String)txnMetadataList.getResponse()).code(txnMetadataList.getCode());
            }
            return this.convertToMetadataJSONContentList((TxMetadata)((List)txnMetadataList.getValue()).get(0));
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Result<List<MetadataJSONContent>> convertToMetadataJSONContentList(TxMetadata txMetadata) {
        ArrayList<MetadataJSONContent> metadataJSONContentList = new ArrayList<MetadataJSONContent>();
        JsonNode metadata = (JsonNode)this.objectMapper.convertValue((Object)txMetadata.getMetadata(), JsonNode.class);
        String txHash = txMetadata.getTxHash();
        Iterator labelIterator = metadata.fieldNames();
        while (labelIterator.hasNext()) {
            String label = (String)labelIterator.next();
            metadataJSONContentList.add(new MetadataJSONContent(txHash, label, metadata.get(label)));
        }
        return Result.success((String)"OK").withValue(metadataJSONContentList).code(200);
    }

    public Result<List<MetadataCBORContent>> getCBORMetadataByTxnHash(String txnHash) {
        throw new UnsupportedOperationException();
    }

    public Result<List<MetadataLabel>> getMetadataLabels(int count, int page, OrderEnum order) throws ApiException {
        try {
            Options options = Options.builder().option((Option)Limit.of((long)count)).option((Option)Offset.of((long)((long)(page - 1) * (long)count))).option((Option)Order.by((String)"key", (SortType)(order == OrderEnum.desc ? SortType.DESC : SortType.ASC))).build();
            rest.koios.client.backend.api.base.Result txMetadataLabelsResult = this.transactionsService.getTransactionMetadataLabels(options);
            if (!txMetadataLabelsResult.isSuccessful()) {
                return Result.error((String)txMetadataLabelsResult.getResponse()).code(txMetadataLabelsResult.getCode());
            }
            return this.convertToMetadataLabels((List)txMetadataLabelsResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Result<List<MetadataLabel>> convertToMetadataLabels(List<TxMetadataLabels> txMetadataLabels) {
        ArrayList metadataLabels = new ArrayList();
        txMetadataLabels.forEach(txMetadataLabel -> metadataLabels.add(new MetadataLabel(txMetadataLabel.getKey(), null, null)));
        return Result.success((String)"OK").withValue(metadataLabels).code(200);
    }

    public Result<List<MetadataJSONContent>> getJSONMetadataByLabel(BigInteger label, int count, int page, OrderEnum order) {
        throw new UnsupportedOperationException();
    }

    public Result<List<MetadataCBORContent>> getCBORMetadataByLabel(BigInteger label, int count, int page, OrderEnum order) {
        throw new UnsupportedOperationException();
    }
}

