/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.TransactionService;
import com.bloxbean.cardano.client.backend.model.TransactionContent;
import com.bloxbean.cardano.client.backend.model.TxContentOutputAmount;
import com.bloxbean.cardano.client.backend.model.TxContentUtxo;
import com.bloxbean.cardano.client.backend.model.TxContentUtxoInputs;
import com.bloxbean.cardano.client.backend.model.TxContentUtxoOutputs;
import com.bloxbean.cardano.client.backend.model.TxOutputAmount;
import java.util.ArrayList;
import java.util.List;
import rest.koios.client.backend.api.common.Asset;
import rest.koios.client.backend.api.transactions.TransactionsService;
import rest.koios.client.backend.api.transactions.model.TxIO;
import rest.koios.client.backend.api.transactions.model.TxInfo;
import rest.koios.client.backend.api.transactions.model.TxPlutusContract;
import rest.koios.client.backend.api.transactions.model.TxUtxo;

public class KoiosTransactionService
implements TransactionService {
    private final TransactionsService transactionsService;

    public KoiosTransactionService(TransactionsService transactionsService) {
        this.transactionsService = transactionsService;
    }

    public Result<String> submitTransaction(byte[] cborData) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result txResult = this.transactionsService.submitTx(cborData);
            if (!txResult.isSuccessful()) {
                return Result.error((String)txResult.getResponse()).withValue((Object)txResult.getResponse()).code(txResult.getCode());
            }
            return Result.success((String)"OK").withValue(txResult.getValue()).code(200);
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<TransactionContent> getTransaction(String txnHash) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result txInfoResult = this.transactionsService.getTransactionInformation(List.of(txnHash), null);
            if (!txInfoResult.isSuccessful()) {
                return Result.error((String)txInfoResult.getResponse()).code(txInfoResult.getCode());
            }
            if (!((List)txInfoResult.getValue()).isEmpty()) {
                return this.convertToTransactionContent((TxInfo)((List)txInfoResult.getValue()).get(0));
            }
            return Result.error((String)"Not Found").code(404);
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Result<TransactionContent> convertToTransactionContent(TxInfo txInfo) {
        TransactionContent transactionContent = new TransactionContent();
        transactionContent.setHash(txInfo.getTxHash());
        transactionContent.setBlock(txInfo.getBlockHash());
        transactionContent.setBlockHeight(txInfo.getBlockHeight());
        transactionContent.setBlockTime(txInfo.getTxTimestamp());
        transactionContent.setSlot(txInfo.getAbsoluteSlot());
        transactionContent.setIndex(txInfo.getTxBlockIndex());
        ArrayList<TxOutputAmount> txOutputAmountList = new ArrayList<TxOutputAmount>();
        txOutputAmountList.add(new TxOutputAmount("lovelace", txInfo.getTotalOutput()));
        for (TxIO txIO : txInfo.getOutputs()) {
            for (Asset txAsset : txIO.getAssetList()) {
                txOutputAmountList.add(new TxOutputAmount(txAsset.getPolicyId() + txAsset.getAssetName(), txAsset.getQuantity()));
            }
        }
        transactionContent.setOutputAmount(txOutputAmountList);
        transactionContent.setFees(txInfo.getFee());
        transactionContent.setDeposit(txInfo.getDeposit());
        transactionContent.setSize(txInfo.getTxSize());
        if (txInfo.getInvalidBefore() != null) {
            transactionContent.setInvalidBefore(txInfo.getInvalidBefore());
        }
        if (txInfo.getInvalidAfter() != null) {
            transactionContent.setInvalidHereafter(txInfo.getInvalidAfter());
        }
        transactionContent.setUtxoCount(Integer.valueOf(txInfo.getOutputs().size() + txInfo.getInputs().size()));
        transactionContent.setWithdrawalCount(Integer.valueOf(txInfo.getWithdrawals().size()));
        int mirCerts = 0;
        int delegations = 0;
        int stakeCerts = 0;
        int poolUpdateCerts = 0;
        int poolRetires = 0;
        if (!txInfo.getCertificates().isEmpty()) {
            for (Object txCertificate : txInfo.getCertificates()) {
                switch (txCertificate.getType()) {
                    case "reserve_MIR": 
                    case "treasury_MIR": {
                        ++mirCerts;
                        break;
                    }
                    case "delegation": {
                        ++delegations;
                        break;
                    }
                    case "pool_retire": {
                        ++poolRetires;
                        break;
                    }
                    case "pool_update": {
                        ++poolUpdateCerts;
                        break;
                    }
                    case "stake_registration": 
                    case "stake_deregistration": {
                        ++stakeCerts;
                        break;
                    }
                }
            }
        }
        transactionContent.setMirCertCount(Integer.valueOf(mirCerts));
        transactionContent.setDelegationCount(Integer.valueOf(delegations));
        transactionContent.setStakeCertCount(Integer.valueOf(stakeCerts));
        transactionContent.setPoolUpdateCount(Integer.valueOf(poolUpdateCerts));
        transactionContent.setPoolRetireCount(Integer.valueOf(poolRetires));
        int assetMintBurnCount = 0;
        if (!txInfo.getAssetsMinted().isEmpty()) {
            for (Asset txAsset : txInfo.getAssetsMinted()) {
                assetMintBurnCount += Integer.parseInt(txAsset.getQuantity().replace("-", ""));
            }
        }
        transactionContent.setAssetMintOrBurnCount(Integer.valueOf(assetMintBurnCount));
        int redeemerCount = 0;
        boolean validContract = true;
        if (txInfo.getPlutusContracts() != null && !txInfo.getPlutusContracts().isEmpty()) {
            for (TxPlutusContract txPlutusContract : txInfo.getPlutusContracts()) {
                validContract = txPlutusContract.getValidContract();
                if (txPlutusContract.getInput().getRedeemer() == null) continue;
                ++redeemerCount;
            }
        }
        transactionContent.setValidContract(Boolean.valueOf(validContract));
        transactionContent.setRedeemerCount(Integer.valueOf(redeemerCount));
        return Result.success((String)"OK").withValue((Object)transactionContent).code(200);
    }

    public Result<TxContentUtxo> getTransactionUtxos(String txnHash) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result txUtxosResult = this.transactionsService.getTransactionUTxOs(List.of(txnHash), null);
            if (!txUtxosResult.isSuccessful()) {
                return Result.error((String)txUtxosResult.getResponse()).code(txUtxosResult.getCode());
            }
            return this.convertToTxContentUtxo((TxUtxo)((List)txUtxosResult.getValue()).get(0));
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Result<TxContentUtxo> convertToTxContentUtxo(TxUtxo txUtxo) {
        TxContentUtxo txContentUtxo = new TxContentUtxo();
        ArrayList<TxContentUtxoInputs> inputs = new ArrayList<TxContentUtxoInputs>();
        for (TxIO txIO : txUtxo.getInputs()) {
            ArrayList<TxContentOutputAmount> txContentOutputAmountList = new ArrayList<TxContentOutputAmount>();
            if (txIO.getValue() != null && !txIO.getValue().isEmpty()) {
                txContentOutputAmountList.add(new TxContentOutputAmount("lovelace", txIO.getValue()));
            }
            for (Asset txAsset : txIO.getAssetList()) {
                txContentOutputAmountList.add(new TxContentOutputAmount(txAsset.getPolicyId() + txAsset.getAssetName(), txAsset.getQuantity()));
            }
            inputs.add(new TxContentUtxoInputs(txIO.getPaymentAddr().getBech32(), txContentOutputAmountList));
        }
        if (!inputs.isEmpty()) {
            txContentUtxo.setInputs(inputs);
        }
        ArrayList<TxContentUtxoOutputs> outputs = new ArrayList<TxContentUtxoOutputs>();
        for (TxIO txIO : txUtxo.getOutputs()) {
            ArrayList<TxContentOutputAmount> txContentOutputAmountList = new ArrayList<TxContentOutputAmount>();
            if (txIO.getValue() != null && !txIO.getValue().isEmpty()) {
                txContentOutputAmountList.add(new TxContentOutputAmount("lovelace", txIO.getValue()));
            }
            for (Asset txAsset : txIO.getAssetList()) {
                txContentOutputAmountList.add(new TxContentOutputAmount(txAsset.getPolicyId() + txAsset.getAssetName(), txAsset.getQuantity()));
            }
            outputs.add(new TxContentUtxoOutputs(txIO.getPaymentAddr().getBech32(), txContentOutputAmountList));
        }
        txContentUtxo.setOutputs(outputs);
        return Result.success((String)"OK").withValue((Object)txContentUtxo).code(200);
    }
}

