/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.backend.api.UtxoService;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rest.koios.client.backend.api.address.AddressService;
import rest.koios.client.backend.api.address.model.AddressInfo;
import rest.koios.client.backend.api.address.model.AddressUtxo;
import rest.koios.client.backend.api.common.Asset;
import rest.koios.client.backend.factory.options.Options;
import rest.koios.client.backend.factory.options.SortType;

public class KoiosUtxoService
implements UtxoService {
    private final AddressService addressService;

    public KoiosUtxoService(AddressService addressService) {
        this.addressService = addressService;
    }

    public Result<List<Utxo>> getUtxos(String address, int count, int page) throws ApiException {
        return this.getUtxos(address, count, page, OrderEnum.desc);
    }

    private Result<List<Utxo>> convertToUTxOs(AddressInfo addressInfo) {
        ArrayList<Utxo> utxoList = new ArrayList<Utxo>();
        for (AddressUtxo addressUtxo : addressInfo.getUtxoSet()) {
            Utxo utxo = new Utxo();
            utxo.setAddress(addressInfo.getAddress());
            utxo.setTxHash(addressUtxo.getTxHash());
            utxo.setOutputIndex(addressUtxo.getTxIndex().intValue());
            utxo.setDataHash(addressUtxo.getDatumHash());
            if (addressUtxo.getInlineDatum() != null) {
                utxo.setInlineDatum(addressUtxo.getInlineDatum().getBytes());
            }
            if (addressUtxo.getReferenceScript() != null) {
                utxo.setReferenceScriptHash(addressUtxo.getReferenceScript().getHash());
            }
            ArrayList<Amount> amountList = new ArrayList<Amount>();
            amountList.add(new Amount("lovelace", new BigInteger(addressUtxo.getValue())));
            for (Asset asset : addressUtxo.getAssetList()) {
                String key = asset.getPolicyId() + asset.getAssetName();
                amountList.add(new Amount(key, new BigInteger(asset.getQuantity())));
            }
            utxo.setAmount(amountList);
            utxoList.add(utxo);
        }
        return Result.success((String)"OK").withValue(utxoList).code(200);
    }

    public Result<List<Utxo>> getUtxos(String address, int count, int page, OrderEnum order) throws ApiException {
        try {
            if (page != 1) {
                return Result.success((String)"OK").withValue(Collections.emptyList()).code(200);
            }
            rest.koios.client.backend.api.base.Result addressInformationResult = order == OrderEnum.asc ? this.addressService.getAddressInformation(List.of(address), SortType.ASC, Options.EMPTY) : this.addressService.getAddressInformation(address);
            if (!addressInformationResult.isSuccessful()) {
                return Result.error((String)addressInformationResult.getResponse()).withValue(Collections.emptyList()).code(addressInformationResult.getCode());
            }
            return this.convertToUTxOs((AddressInfo)addressInformationResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

