/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.AddressService;
import com.bloxbean.cardano.client.backend.model.AddressContent;
import com.bloxbean.cardano.client.backend.model.AddressDetails;
import com.bloxbean.cardano.client.backend.model.AddressTransactionContent;
import com.bloxbean.cardano.client.backend.model.TxContentOutputAmount;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import rest.koios.client.backend.api.address.model.AddressInfo;
import rest.koios.client.backend.api.address.model.AddressUtxo;
import rest.koios.client.backend.api.base.common.Asset;
import rest.koios.client.backend.api.base.common.TxHash;
import rest.koios.client.backend.factory.options.Limit;
import rest.koios.client.backend.factory.options.Offset;
import rest.koios.client.backend.factory.options.Option;
import rest.koios.client.backend.factory.options.Options;
import rest.koios.client.backend.factory.options.Order;
import rest.koios.client.backend.factory.options.SortType;
import rest.koios.client.backend.factory.options.filters.Filter;
import rest.koios.client.backend.factory.options.filters.FilterType;

public class KoiosAddressService
implements AddressService {
    private final rest.koios.client.backend.api.address.AddressService addressService;

    public KoiosAddressService(rest.koios.client.backend.api.address.AddressService addressService) {
        this.addressService = addressService;
    }

    public Result<AddressContent> getAddressInfo(String address) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result addressInformationResult = this.addressService.getAddressInformation(address);
            if (!addressInformationResult.isSuccessful()) {
                return Result.error((String)addressInformationResult.getResponse()).code(addressInformationResult.getCode());
            }
            return this.convertToAddressContent((AddressInfo)addressInformationResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<AddressDetails> getAddressDetails(String address) throws ApiException {
        throw new UnsupportedOperationException("Not yet supported");
    }

    private Result<AddressContent> convertToAddressContent(AddressInfo addressInfo) {
        AddressContent addressContent = new AddressContent();
        addressContent.setStakeAddress(addressInfo.getStakeAddress());
        if (addressContent.getStakeAddress() == null || addressContent.getStakeAddress().isEmpty()) {
            addressContent.setType(AddressContent.TypeEnum.BYRON);
        } else {
            addressContent.setType(AddressContent.TypeEnum.SHELLEY);
        }
        HashMap<CallSite, TxContentOutputAmount> assetMap = new HashMap<CallSite, TxContentOutputAmount>();
        for (AddressUtxo addressUtxo : addressInfo.getUtxoSet()) {
            for (Asset asset : addressUtxo.getAssetList()) {
                String key = asset.getPolicyId() + asset.getAssetName();
                if (assetMap.containsKey(key)) {
                    ((TxContentOutputAmount)assetMap.get(key)).setQuantity(String.valueOf(Long.parseLong(((TxContentOutputAmount)assetMap.get(key)).getQuantity()) + Long.parseLong(asset.getQuantity())));
                    continue;
                }
                assetMap.put((CallSite)((Object)key), new TxContentOutputAmount(key, asset.getQuantity()));
            }
        }
        ArrayList txContentOutputAmountList = new ArrayList(assetMap.values());
        txContentOutputAmountList.sort(Comparator.comparing(TxContentOutputAmount::getUnit));
        txContentOutputAmountList.add(0, new TxContentOutputAmount("lovelace", addressInfo.getBalance()));
        addressContent.setAmount(txContentOutputAmountList);
        addressContent.setScript(addressInfo.getScriptAddress());
        return Result.success((String)"OK").withValue((Object)addressContent).code(200);
    }

    public Result<List<AddressTransactionContent>> getTransactions(String address, int count, int page) throws ApiException {
        return this.getTransactions(address, count, page, OrderEnum.asc);
    }

    public Result<List<AddressTransactionContent>> getTransactions(String address, int count, int page, OrderEnum order) throws ApiException {
        return this.getTransactions(address, count, page, order, null, null);
    }

    public Result<List<AddressTransactionContent>> getTransactions(String address, int count, int page, OrderEnum order, String from, String to) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result addressUTxOsResult;
            Order ordering = Order.by((String)"block_time", (SortType)SortType.ASC);
            if (order == OrderEnum.desc) {
                ordering = Order.by((String)"block_time", (SortType)SortType.DESC);
            }
            Options options = Options.builder().option((Option)Limit.of((long)count)).option((Option)Offset.of((long)((long)(page - 1) * (long)count))).option((Option)ordering).build();
            if (to != null && !to.isEmpty()) {
                options.getOptionList().add(Filter.of((String)"block_height", (FilterType)FilterType.LTE, (String)to));
            }
            if (from == null) {
                from = "0";
            }
            if (!(addressUTxOsResult = this.addressService.getAddressTransactions(List.of(address), Integer.valueOf(Integer.parseInt(from)), options)).isSuccessful()) {
                return Result.error((String)addressUTxOsResult.getResponse()).code(addressUTxOsResult.getCode());
            }
            return this.convertToAddressTransactionContent((List)addressUTxOsResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ParseException e) {
            throw new ApiException("Failed to Parse Date: " + e.getMessage(), (Exception)e);
        }
    }

    public Result<List<AddressTransactionContent>> getAllTransactions(String address, OrderEnum order, Integer fromBlockHeight, Integer toBlockHeight) throws ApiException {
        ArrayList addressTransactionContents = new ArrayList();
        int page = 1;
        Result<List<AddressTransactionContent>> addressTransactionsResult = this.getTransactions(address, 1000, page, order, fromBlockHeight.toString(), toBlockHeight.toString());
        while (addressTransactionsResult.isSuccessful()) {
            addressTransactionContents.addAll((Collection)addressTransactionsResult.getValue());
            if (((List)addressTransactionsResult.getValue()).size() != 1000) break;
            addressTransactionsResult = this.getTransactions(address, 1000, ++page, order, fromBlockHeight.toString(), toBlockHeight.toString());
        }
        if (!addressTransactionsResult.isSuccessful()) {
            return addressTransactionsResult;
        }
        addressTransactionContents.sort((o1, o2) -> order == OrderEnum.asc ? Long.compare(o1.getBlockHeight(), o2.getBlockHeight()) : Long.compare(o2.getBlockHeight(), o1.getBlockHeight()));
        return Result.success((String)addressTransactionsResult.toString()).withValue(addressTransactionContents).code(addressTransactionsResult.code());
    }

    private Result<List<AddressTransactionContent>> convertToAddressTransactionContent(List<TxHash> txHashes) throws ParseException {
        ArrayList<AddressTransactionContent> addressTransactionContents = new ArrayList<AddressTransactionContent>();
        for (TxHash txHash : txHashes) {
            AddressTransactionContent addressTransactionContent = new AddressTransactionContent();
            addressTransactionContent.setTxHash(txHash.getTxHash());
            addressTransactionContent.setBlockHeight((long)txHash.getBlockHeight().intValue());
            addressTransactionContent.setBlockTime((long)txHash.getBlockTime().intValue());
            addressTransactionContents.add(addressTransactionContent);
        }
        return Result.success((String)"OK").withValue(addressTransactionContents).code(200);
    }
}

