/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.BlockService;
import com.bloxbean.cardano.client.backend.model.Block;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.List;
import rest.koios.client.backend.api.block.model.BlockInfo;
import rest.koios.client.backend.factory.options.Limit;
import rest.koios.client.backend.factory.options.Option;
import rest.koios.client.backend.factory.options.Options;
import rest.koios.client.backend.factory.options.filters.Filter;
import rest.koios.client.backend.factory.options.filters.FilterType;

public class KoiosBlockService
implements BlockService {
    private final rest.koios.client.backend.api.block.BlockService blockService;

    public KoiosBlockService(rest.koios.client.backend.api.block.BlockService blockService) {
        this.blockService = blockService;
    }

    public Result<Block> getLatestBlock() throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result blockList = this.blockService.getBlockList(Options.builder().option((Option)Limit.of((long)1L)).build());
            if (!blockList.isSuccessful()) {
                return Result.error((String)blockList.getResponse()).code(blockList.getCode());
            }
            return this.convertToBlock((rest.koios.client.backend.api.block.model.Block)((List)blockList.getValue()).get(0));
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<Block> getBlockByHash(String blockHash) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result blockInfo = this.blockService.getBlockInformation(blockHash);
            if (!blockInfo.isSuccessful()) {
                return Result.error((String)blockInfo.getResponse()).code(blockInfo.getCode());
            }
            return this.convertToBlock((BlockInfo)blockInfo.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ParseException e) {
            return Result.error((String)"Failed to Parse System Start Date").code(500);
        }
    }

    private Result<Block> convertToBlock(rest.koios.client.backend.api.block.model.Block bl) {
        Block block = new Block();
        block.setTime(bl.getBlockTime().longValue());
        block.setHeight((long)bl.getBlockHeight().intValue());
        block.setHash(bl.getHash());
        block.setSlot((long)bl.getAbsSlot().intValue());
        block.setEpoch(bl.getEpochNo());
        block.setEpochSlot(bl.getEpochSlot());
        block.setSlotLeader(bl.getPool());
        block.setSize(bl.getBlockSize());
        block.setTxCount(bl.getTxCount());
        block.setBlockVrf(bl.getVrfKey());
        block.setPreviousBlock(bl.getParentHash());
        return Result.success((String)"OK").withValue((Object)block).code(200);
    }

    private Result<Block> convertToBlock(BlockInfo blockInfo) throws ParseException {
        Block block = new Block();
        block.setTime(blockInfo.getBlockTime().longValue());
        block.setHeight((long)blockInfo.getBlockHeight().intValue());
        block.setHash(blockInfo.getHash());
        block.setSlot((long)blockInfo.getAbsSlot().intValue());
        block.setEpoch(blockInfo.getEpochNo());
        block.setEpochSlot(blockInfo.getEpochSlot());
        block.setSlotLeader(blockInfo.getPool());
        block.setSize(blockInfo.getBlockSize());
        block.setTxCount(blockInfo.getTxCount());
        block.setOutput(blockInfo.getTotalOutput());
        block.setFees(blockInfo.getTotalFees());
        block.setBlockVrf(blockInfo.getVrfKey());
        block.setPreviousBlock(blockInfo.getParentHash());
        block.setNextBlock(blockInfo.getChildHash());
        block.setConfirmations(blockInfo.getNumConfirmations());
        return Result.success((String)"OK").withValue((Object)block).code(200);
    }

    public Result<Block> getBlockByNumber(BigInteger blockNumber) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result blockList = this.blockService.getBlockList(Options.builder().option((Option)Filter.of((String)"block_height", (FilterType)FilterType.EQ, (String)blockNumber.toString())).build());
            if (!blockList.isSuccessful()) {
                return Result.error((String)blockList.getResponse()).code(blockList.getCode());
            }
            return this.getBlockByHash(((rest.koios.client.backend.api.block.model.Block)((List)blockList.getValue()).get(0)).getHash());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

