/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.ProtocolParams;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.model.EpochContent;
import com.bloxbean.cardano.client.plutus.util.PlutusOps;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import rest.koios.client.backend.api.epoch.EpochService;
import rest.koios.client.backend.api.epoch.model.EpochInfo;
import rest.koios.client.backend.api.epoch.model.EpochParams;

public class KoiosEpochService
implements com.bloxbean.cardano.client.backend.api.EpochService {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final EpochService epochService;

    public KoiosEpochService(EpochService epochService) {
        this.epochService = epochService;
    }

    private List<String> getInnerKeys(String key, JsonNode costModels) {
        ArrayList<String> keys = new ArrayList<String>();
        JsonNode node = costModels.path(key);
        if (node.isInt()) {
            return List.of(key);
        }
        if (node.isTextual()) {
            return Collections.emptyList();
        }
        Iterator stringIterator = costModels.path(key).fieldNames();
        while (stringIterator.hasNext()) {
            List<String> getKeys = this.getInnerKeys((String)stringIterator.next(), costModels.path(key));
            for (String innerKey : getKeys) {
                keys.add(key + "-" + innerKey);
            }
        }
        return keys;
    }

    public Result<EpochContent> getLatestEpoch() throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result epochInformationResult = this.epochService.getLatestEpochInfo();
            if (!epochInformationResult.isSuccessful()) {
                return Result.error((String)epochInformationResult.getResponse()).code(epochInformationResult.getCode());
            }
            return this.convertToEpochContent((EpochInfo)epochInformationResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<EpochContent> getEpoch(Integer epoch) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result epochInformationResult = this.epochService.getEpochInformationByEpoch(epoch);
            if (!epochInformationResult.isSuccessful()) {
                return Result.error((String)epochInformationResult.getResponse()).code(epochInformationResult.getCode());
            }
            return this.convertToEpochContent((EpochInfo)epochInformationResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<ProtocolParams> getProtocolParameters(Integer epoch) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result epochParametersResult = this.epochService.getEpochParametersByEpoch(epoch);
            if (!epochParametersResult.isSuccessful()) {
                return Result.error((String)epochParametersResult.getResponse()).code(epochParametersResult.getCode());
            }
            return this.convertToProtocolParams((EpochParams)epochParametersResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<ProtocolParams> getProtocolParameters() throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result epochParametersResult = this.epochService.getLatestEpochParameters();
            if (!epochParametersResult.isSuccessful()) {
                return Result.error((String)epochParametersResult.getResponse()).code(epochParametersResult.getCode());
            }
            return this.convertToProtocolParams((EpochParams)epochParametersResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Result<EpochContent> convertToEpochContent(EpochInfo epochInfo) {
        EpochContent epochContent = new EpochContent();
        epochContent.setEpoch(epochInfo.getEpochNo());
        epochContent.setStartTime(epochInfo.getStartTime().longValue());
        epochContent.setEndTime(epochInfo.getEndTime().longValue());
        epochContent.setFirstBlockTime(epochInfo.getFirstBlockTime().longValue());
        epochContent.setLastBlockTime(epochInfo.getLastBlockTime().longValue());
        epochContent.setBlockCount(epochInfo.getBlkCount());
        epochContent.setTxCount(epochInfo.getTxCount());
        epochContent.setOutput(epochInfo.getOutSum());
        epochContent.setFees(epochInfo.getFees());
        epochContent.setActiveStake(epochInfo.getActiveStake());
        return Result.success((String)"OK").withValue((Object)epochContent).code(200);
    }

    private Result<ProtocolParams> convertToProtocolParams(EpochParams epochParams) {
        ProtocolParams protocolParams = new ProtocolParams();
        protocolParams.setMinFeeA(epochParams.getMinFeeA());
        protocolParams.setMinFeeB(epochParams.getMinFeeB());
        protocolParams.setMaxBlockSize(epochParams.getMaxBlockSize());
        protocolParams.setMaxTxSize(epochParams.getMaxTxSize());
        protocolParams.setMaxBlockHeaderSize(epochParams.getMaxBhSize());
        protocolParams.setKeyDeposit(epochParams.getKeyDeposit());
        protocolParams.setPoolDeposit(epochParams.getPoolDeposit());
        protocolParams.setEMax(epochParams.getMaxEpoch());
        protocolParams.setNOpt(epochParams.getOptimalPoolCount());
        protocolParams.setA0(epochParams.getInfluence());
        protocolParams.setRho(epochParams.getMonetaryExpandRate());
        protocolParams.setTau(epochParams.getTreasuryGrowthRate());
        protocolParams.setDecentralisationParam(epochParams.getDecentralisation());
        protocolParams.setExtraEntropy(epochParams.getExtraEntropy());
        protocolParams.setProtocolMajorVer(epochParams.getProtocolMajor());
        protocolParams.setProtocolMinorVer(epochParams.getProtocolMinor());
        protocolParams.setMinUtxo(epochParams.getMinUtxoValue());
        protocolParams.setMinPoolCost(epochParams.getMinPoolCost());
        protocolParams.setNonce(epochParams.getNonce());
        if (epochParams.getPriceMem() != null) {
            protocolParams.setPriceMem(epochParams.getPriceMem());
        }
        if (epochParams.getPriceStep() != null) {
            protocolParams.setPriceStep(epochParams.getPriceStep());
        }
        if (epochParams.getMaxTxExMem() != null) {
            protocolParams.setMaxTxExMem(epochParams.getMaxTxExMem());
        }
        if (epochParams.getMaxTxExSteps() != null) {
            protocolParams.setMaxTxExSteps(epochParams.getMaxTxExSteps());
        }
        if (epochParams.getMaxBlockExMem() != null) {
            protocolParams.setMaxBlockExMem(epochParams.getMaxBlockExMem());
        }
        if (epochParams.getMaxBlockExSteps() != null) {
            protocolParams.setMaxBlockExSteps(epochParams.getMaxBlockExSteps());
        }
        if (epochParams.getMaxValSize() != null) {
            protocolParams.setMaxValSize(epochParams.getMaxValSize());
        }
        if (epochParams.getCollateralPercent() != null) {
            protocolParams.setCollateralPercent(BigDecimal.valueOf(epochParams.getCollateralPercent().intValue()));
        }
        if (epochParams.getMaxCollateralInputs() != null) {
            protocolParams.setMaxCollateralInputs(epochParams.getMaxCollateralInputs());
        }
        if (epochParams.getCostModels() != null) {
            protocolParams.setCostModels(this.convertToCostModels(epochParams.getCostModels()));
        }
        if (epochParams.getCoinsPerUtxoSize() != null) {
            protocolParams.setCoinsPerUtxoSize(epochParams.getCoinsPerUtxoSize());
        }
        protocolParams.setPvtMotionNoConfidence(epochParams.getPvtMotionNoConfidence());
        protocolParams.setPvtCommitteeNormal(epochParams.getPvtCommitteeNormal());
        protocolParams.setPvtCommitteeNoConfidence(epochParams.getPvtCommitteeNoConfidence());
        protocolParams.setPvtHardForkInitiation(epochParams.getPvtHardForkInitiation());
        protocolParams.setPvtPPSecurityGroup(epochParams.getPvtppSecurityGroup());
        protocolParams.setDvtMotionNoConfidence(epochParams.getDvtMotionNoConfidence());
        protocolParams.setDvtCommitteeNormal(epochParams.getDvtCommitteeNormal());
        protocolParams.setDvtCommitteeNoConfidence(epochParams.getDvtCommitteeNoConfidence());
        protocolParams.setDvtUpdateToConstitution(epochParams.getDvtUpdateToConstitution());
        protocolParams.setDvtHardForkInitiation(epochParams.getDvtHardForkInitiation());
        protocolParams.setDvtPPNetworkGroup(epochParams.getDvtPPNetworkGroup());
        protocolParams.setDvtPPEconomicGroup(epochParams.getDvtPPEconomicGroup());
        protocolParams.setDvtPPTechnicalGroup(epochParams.getDvtPPTechnicalGroup());
        protocolParams.setDvtPPGovGroup(epochParams.getDvtPPGovGroup());
        protocolParams.setDvtTreasuryWithdrawal(epochParams.getDvtTreasuryWithdrawal());
        protocolParams.setCommitteeMinSize(epochParams.getCommitteeMinSize());
        protocolParams.setCommitteeMaxTermLength(epochParams.getCommitteeMaxTermLength());
        protocolParams.setGovActionLifetime(epochParams.getGovActionLifetime());
        if (epochParams.getGovActionDeposit() != null) {
            protocolParams.setGovActionDeposit(new BigInteger(epochParams.getGovActionDeposit().trim()));
        }
        if (epochParams.getDrepDeposit() != null) {
            protocolParams.setDrepDeposit(new BigInteger(epochParams.getDrepDeposit().trim()));
        }
        protocolParams.setDrepActivity(epochParams.getDrepActivity());
        protocolParams.setMinFeeRefScriptCostPerByte(epochParams.getMinFeeRefScriptCostPerByte());
        return Result.success((String)"OK").withValue((Object)protocolParams).code(200);
    }

    private LinkedHashMap<String, LinkedHashMap<String, Long>> convertToCostModels(JsonNode costModelsJsonNode) {
        String costModelsJson = costModelsJsonNode.asText();
        try {
            costModelsJson = this.objectMapper.writeValueAsString((Object)costModelsJsonNode);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        LinkedHashMap<String, LinkedHashMap<String, Long>> res = new LinkedHashMap<String, LinkedHashMap<String, Long>>();
        try {
            LinkedHashMap result = (LinkedHashMap)this.objectMapper.readValue(costModelsJson, (TypeReference)new TypeReference<LinkedHashMap<String, List<Long>>>(){});
            AtomicInteger plutusV1IndexHolder = new AtomicInteger();
            LinkedHashMap plutusV1CostModelsMap = new LinkedHashMap();
            AtomicInteger plutusV2IndexHolder = new AtomicInteger();
            LinkedHashMap plutusV2CostModelsMap = new LinkedHashMap();
            AtomicInteger plutusV3IndexHolder = new AtomicInteger();
            LinkedHashMap plutusV3CostModelsMap = new LinkedHashMap();
            result.forEach((key, value) -> {
                if (key.equals("PlutusV1")) {
                    value.forEach(aLong -> {
                        int index = plutusV1IndexHolder.getAndIncrement();
                        plutusV1CostModelsMap.put((String)PlutusOps.getOperations((int)1).get(index), aLong);
                    });
                    res.put((String)key, plutusV1CostModelsMap);
                } else if (key.equals("PlutusV2")) {
                    value.forEach(aLong -> {
                        int index = plutusV2IndexHolder.getAndIncrement();
                        plutusV2CostModelsMap.put((String)PlutusOps.getOperations((int)2).get(index), aLong);
                    });
                    res.put((String)key, plutusV2CostModelsMap);
                } else if (key.equals("PlutusV3")) {
                    value.forEach(aLong -> {
                        int index = plutusV3IndexHolder.getAndIncrement();
                        plutusV3CostModelsMap.put((String)PlutusOps.getOperations((int)3).get(index), aLong);
                    });
                    res.put((String)key, plutusV3CostModelsMap);
                }
            });
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return res;
    }
}

