/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.model.ScriptDatum;
import com.bloxbean.cardano.client.backend.model.ScriptDatumCbor;
import com.bloxbean.cardano.client.util.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import rest.koios.client.backend.api.script.ScriptService;
import rest.koios.client.backend.api.script.model.DatumInfo;
import rest.koios.client.backend.api.script.model.PlutusScript;
import rest.koios.client.backend.api.script.model.ScriptInfo;
import rest.koios.client.backend.api.transactions.TransactionsService;
import rest.koios.client.backend.api.transactions.model.TxInfo;
import rest.koios.client.backend.api.transactions.model.TxPlutusContract;
import rest.koios.client.backend.factory.options.Option;
import rest.koios.client.backend.factory.options.Options;
import rest.koios.client.backend.factory.options.filters.Filter;
import rest.koios.client.backend.factory.options.filters.FilterType;

public class KoiosScriptService
implements com.bloxbean.cardano.client.backend.api.ScriptService {
    private final ScriptService scriptService;
    private final TransactionsService transactionsService;

    public KoiosScriptService(ScriptService scriptService, TransactionsService transactionsService) {
        this.scriptService = scriptService;
        this.transactionsService = transactionsService;
    }

    public Result<ScriptDatum> getScriptDatum(String datumHash) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result datumInfoListResult = this.scriptService.getDatumInformation(List.of(datumHash), Options.EMPTY);
            if (!datumInfoListResult.isSuccessful()) {
                return Result.error((String)datumInfoListResult.getResponse()).code(datumInfoListResult.getCode());
            }
            if (((List)datumInfoListResult.getValue()).isEmpty()) {
                return Result.error((String)"Not Found").code(404);
            }
            return this.convertToScriptDatum((DatumInfo)((List)datumInfoListResult.getValue()).get(0));
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Result<ScriptDatum> convertToScriptDatum(DatumInfo datumInfo) {
        ScriptDatum scriptDatum = new ScriptDatum();
        scriptDatum.setJsonValue(datumInfo.getValue());
        return Result.success((String)"OK").withValue((Object)scriptDatum).code(200);
    }

    public Result<ScriptDatumCbor> getScriptDatumCbor(String datumHash) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result datumInfoListResult = this.scriptService.getDatumInformation(List.of(datumHash), Options.EMPTY);
            if (!datumInfoListResult.isSuccessful()) {
                return Result.error((String)datumInfoListResult.getResponse()).code(datumInfoListResult.getCode());
            }
            if (((List)datumInfoListResult.getValue()).isEmpty()) {
                return Result.error((String)"Not Found").code(404);
            }
            ScriptDatumCbor scriptDatumCbor = new ScriptDatumCbor();
            scriptDatumCbor.setCbor(((DatumInfo)((List)datumInfoListResult.getValue()).get(0)).getBytes());
            return Result.success((String)"OK").withValue((Object)scriptDatumCbor).code(200);
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<JsonNode> getNativeScriptJson(String scriptHash) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result scriptInfoListResult = this.scriptService.getScriptInformation(List.of(scriptHash), Options.EMPTY);
            if (!scriptInfoListResult.isSuccessful()) {
                return Result.error((String)scriptInfoListResult.getResponse()).code(scriptInfoListResult.getCode());
            }
            if (((List)scriptInfoListResult.getValue()).isEmpty()) {
                return Result.error((String)"Not Found").code(404);
            }
            return Result.success((String)"OK").withValue((Object)((ScriptInfo)((List)scriptInfoListResult.getValue()).get(0)).getValue()).code(200);
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<String> getPlutusScriptCbor(String scriptHash) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result plutusScriptListResult = this.scriptService.getPlutusScriptList(Options.builder().option((Option)Filter.of((String)"script_hash", (FilterType)FilterType.EQ, (String)scriptHash)).build());
            if (!plutusScriptListResult.isSuccessful()) {
                return Result.error((String)plutusScriptListResult.getResponse()).code(plutusScriptListResult.getCode());
            }
            if (((List)plutusScriptListResult.getValue()).isEmpty()) {
                return Result.error((String)"Not Found").code(404);
            }
            rest.koios.client.backend.api.base.Result txInfoResult = this.transactionsService.getTransactionInformation(((PlutusScript)((List)plutusScriptListResult.getValue()).get(0)).getCreationTxHash());
            if (!txInfoResult.isSuccessful()) {
                return Result.error((String)txInfoResult.getResponse()).code(txInfoResult.getCode());
            }
            if (txInfoResult.getValue() == null) {
                return Result.error((String)"Not Found").code(404);
            }
            String txPlutusContractV1Cbor = ((TxInfo)txInfoResult.getValue()).getPlutusContracts().stream().filter(plutusContract -> plutusContract.getScriptHash().equals(scriptHash)).findFirst().map(TxPlutusContract::getBytecode).orElse(null);
            if (!StringUtils.isEmpty((String)txPlutusContractV1Cbor)) {
                return Result.success((String)"OK").withValue((Object)txPlutusContractV1Cbor).code(200);
            }
            String txPlutusContractV2Cbor = ((TxInfo)txInfoResult.getValue()).getOutputs().stream().filter(txIO -> txIO.getReferenceScript() != null && txIO.getReferenceScript().getHash().equals(scriptHash)).findFirst().map(txIO -> txIO.getReferenceScript().getBytes()).orElse(null);
            if (!StringUtils.isEmpty((String)txPlutusContractV2Cbor)) {
                return Result.success((String)"OK").withValue((Object)txPlutusContractV2Cbor).code(200);
            }
            return Result.error((String)"Not Found").code(404);
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

