/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.TransactionService;
import com.bloxbean.cardano.client.backend.model.TransactionContent;
import com.bloxbean.cardano.client.backend.model.TxContentOutputAmount;
import com.bloxbean.cardano.client.backend.model.TxContentRedeemers;
import com.bloxbean.cardano.client.backend.model.TxContentUtxo;
import com.bloxbean.cardano.client.backend.model.TxContentUtxoInputs;
import com.bloxbean.cardano.client.backend.model.TxContentUtxoOutputs;
import com.bloxbean.cardano.client.backend.model.TxOutputAmount;
import com.bloxbean.cardano.client.plutus.spec.RedeemerTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import rest.koios.client.backend.api.base.common.Asset;
import rest.koios.client.backend.api.transactions.TransactionsService;
import rest.koios.client.backend.api.transactions.model.TxIO;
import rest.koios.client.backend.api.transactions.model.TxInfo;
import rest.koios.client.backend.api.transactions.model.TxPlutusContract;

public class KoiosTransactionService
implements TransactionService {
    private final TransactionsService transactionsService;

    public KoiosTransactionService(TransactionsService transactionsService) {
        this.transactionsService = transactionsService;
    }

    public Result<String> submitTransaction(byte[] cborData) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result txResult = this.transactionsService.submitTx(cborData);
            if (!txResult.isSuccessful()) {
                return Result.error((String)txResult.getResponse()).withValue((Object)txResult.getResponse()).code(txResult.getCode());
            }
            return Result.success((String)"OK").withValue(txResult.getValue()).code(200);
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<TransactionContent> getTransaction(String txnHash) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result txInfoResult = this.transactionsService.getTransactionInformation(List.of(txnHash), null);
            if (!txInfoResult.isSuccessful()) {
                return Result.error((String)txInfoResult.getResponse()).code(txInfoResult.getCode());
            }
            if (!((List)txInfoResult.getValue()).isEmpty()) {
                return Result.success((String)"OK").withValue((Object)this.convertToTransactionContent((TxInfo)((List)txInfoResult.getValue()).get(0))).code(200);
            }
            return Result.error((String)"Not Found").code(404);
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<List<TransactionContent>> getTransactions(List<String> txnHashCollection) throws ApiException {
        ArrayList result = new ArrayList();
        List partitioned = ListUtils.partition(txnHashCollection, (int)1000);
        for (List txIds : partitioned) {
            try {
                rest.koios.client.backend.api.base.Result txInfoResult = this.transactionsService.getTransactionInformation(txIds, null);
                if (!txInfoResult.isSuccessful()) {
                    return Result.error((String)txInfoResult.getResponse()).code(txInfoResult.getCode());
                }
                if (!((List)txInfoResult.getValue()).isEmpty()) {
                    ((List)txInfoResult.getValue()).forEach(txInfo -> result.add(this.convertToTransactionContent((TxInfo)txInfo)));
                    continue;
                }
                return Result.error((String)"Not Found").code(404);
            }
            catch (rest.koios.client.backend.api.base.exception.ApiException e) {
                throw new ApiException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return Result.success((String)"OK").withValue(result).code(200);
    }

    private TransactionContent convertToTransactionContent(TxInfo txInfo) {
        TransactionContent transactionContent = new TransactionContent();
        transactionContent.setHash(txInfo.getTxHash());
        transactionContent.setBlock(txInfo.getBlockHash());
        if (txInfo.getBlockHeight() != null) {
            transactionContent.setBlockHeight(Long.valueOf(txInfo.getBlockHeight()));
        }
        if (txInfo.getTxTimestamp() != null) {
            transactionContent.setBlockTime(Long.valueOf(txInfo.getTxTimestamp()));
        }
        if (txInfo.getAbsoluteSlot() != null) {
            transactionContent.setSlot(Long.valueOf(txInfo.getAbsoluteSlot()));
        }
        transactionContent.setIndex(txInfo.getTxBlockIndex());
        ArrayList<TxOutputAmount> txOutputAmountList = new ArrayList<TxOutputAmount>();
        txOutputAmountList.add(new TxOutputAmount("lovelace", txInfo.getTotalOutput()));
        for (TxIO txIO : txInfo.getOutputs()) {
            for (Asset txAsset : txIO.getAssetList()) {
                txOutputAmountList.add(new TxOutputAmount(txAsset.getPolicyId() + txAsset.getAssetName(), txAsset.getQuantity()));
            }
        }
        transactionContent.setOutputAmount(txOutputAmountList);
        transactionContent.setFees(txInfo.getFee());
        transactionContent.setDeposit(txInfo.getDeposit());
        transactionContent.setSize(txInfo.getTxSize());
        if (txInfo.getInvalidBefore() != null) {
            transactionContent.setInvalidBefore(txInfo.getInvalidBefore());
        }
        if (txInfo.getInvalidAfter() != null) {
            transactionContent.setInvalidHereafter(txInfo.getInvalidAfter());
        }
        transactionContent.setUtxoCount(Integer.valueOf(txInfo.getOutputs().size() + txInfo.getInputs().size()));
        transactionContent.setWithdrawalCount(Integer.valueOf(txInfo.getWithdrawals().size()));
        int mirCerts = 0;
        int delegations = 0;
        int stakeCerts = 0;
        int poolUpdateCerts = 0;
        int poolRetires = 0;
        if (!txInfo.getCertificates().isEmpty()) {
            for (Object txCertificate : txInfo.getCertificates()) {
                switch (txCertificate.getType()) {
                    case "reserve_MIR": 
                    case "treasury_MIR": {
                        ++mirCerts;
                        break;
                    }
                    case "delegation": {
                        ++delegations;
                        break;
                    }
                    case "pool_retire": {
                        ++poolRetires;
                        break;
                    }
                    case "pool_update": {
                        ++poolUpdateCerts;
                        break;
                    }
                    case "stake_registration": 
                    case "stake_deregistration": {
                        ++stakeCerts;
                        break;
                    }
                }
            }
        }
        transactionContent.setMirCertCount(Integer.valueOf(mirCerts));
        transactionContent.setDelegationCount(Integer.valueOf(delegations));
        transactionContent.setStakeCertCount(Integer.valueOf(stakeCerts));
        transactionContent.setPoolUpdateCount(Integer.valueOf(poolUpdateCerts));
        transactionContent.setPoolRetireCount(Integer.valueOf(poolRetires));
        int assetMintBurnCount = 0;
        if (!txInfo.getAssetsMinted().isEmpty()) {
            for (Asset txAsset : txInfo.getAssetsMinted()) {
                assetMintBurnCount += Integer.parseInt(txAsset.getQuantity().replace("-", ""));
            }
        }
        transactionContent.setAssetMintOrBurnCount(Integer.valueOf(assetMintBurnCount));
        int redeemerCount = 0;
        boolean validContract = true;
        if (txInfo.getPlutusContracts() != null && !txInfo.getPlutusContracts().isEmpty()) {
            for (TxPlutusContract txPlutusContract : txInfo.getPlutusContracts()) {
                validContract = txPlutusContract.getValidContract();
                if (txPlutusContract.getInput().getRedeemer() == null) continue;
                ++redeemerCount;
            }
        }
        transactionContent.setValidContract(Boolean.valueOf(validContract));
        transactionContent.setRedeemerCount(Integer.valueOf(redeemerCount));
        return transactionContent;
    }

    public Result<TxContentUtxo> getTransactionUtxos(String txnHash) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result txInfoResult = this.transactionsService.getTransactionInformation(txnHash);
            if (!txInfoResult.isSuccessful()) {
                return Result.error((String)txInfoResult.getResponse()).code(txInfoResult.getCode());
            }
            return this.convertToTxContentUtxo((TxInfo)txInfoResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<List<TxContentRedeemers>> getTransactionRedeemers(String txnHash) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result txInfoResult = this.transactionsService.getTransactionInformation(txnHash);
            if (!txInfoResult.isSuccessful()) {
                return Result.error((String)txInfoResult.getResponse()).code(txInfoResult.getCode());
            }
            return this.convertToTxContentRedeemers((TxInfo)txInfoResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Result<List<TxContentRedeemers>> convertToTxContentRedeemers(TxInfo txInfo) {
        ArrayList<TxContentRedeemers> txContentRedeemersList = new ArrayList<TxContentRedeemers>();
        if (txInfo.getPlutusContracts() != null) {
            int index = 0;
            Collections.reverse(txInfo.getPlutusContracts());
            for (TxPlutusContract txPlutusContract : txInfo.getPlutusContracts()) {
                TxContentRedeemers txContentRedeemers = new TxContentRedeemers();
                txContentRedeemers.setTxIndex(Integer.valueOf(index++));
                txContentRedeemers.setPurpose(RedeemerTag.convert((String)txPlutusContract.getInput().getRedeemer().getPurpose().name()));
                txContentRedeemers.setScriptHash(txPlutusContract.getScriptHash());
                txContentRedeemers.setRedeemerDataHash(txPlutusContract.getInput().getRedeemer().getDatum().getHash());
                txContentRedeemers.setDatumHash(txPlutusContract.getInput().getRedeemer().getDatum().getHash());
                txContentRedeemers.setUnitMem(String.valueOf(txPlutusContract.getInput().getRedeemer().getUnit().getMem()));
                txContentRedeemers.setUnitSteps(String.valueOf(txPlutusContract.getInput().getRedeemer().getUnit().getSteps()));
                txContentRedeemers.setFee(txPlutusContract.getInput().getRedeemer().getFee());
                txContentRedeemersList.add(txContentRedeemers);
            }
        }
        return Result.success((String)"OK").withValue(txContentRedeemersList).code(200);
    }

    private Result<TxContentUtxo> convertToTxContentUtxo(TxInfo txInfo) {
        TxContentUtxo txContentUtxo = new TxContentUtxo();
        ArrayList<TxContentUtxoInputs> inputs = new ArrayList<TxContentUtxoInputs>();
        for (TxIO txIO : txInfo.getInputs()) {
            ArrayList<TxContentOutputAmount> txContentOutputAmountList = new ArrayList<TxContentOutputAmount>();
            if (txIO.getValue() != null && !txIO.getValue().isEmpty()) {
                txContentOutputAmountList.add(new TxContentOutputAmount("lovelace", txIO.getValue()));
            }
            for (Object txAsset : txIO.getAssetList()) {
                txContentOutputAmountList.add(new TxContentOutputAmount(txAsset.getPolicyId() + txAsset.getAssetName(), txAsset.getQuantity()));
            }
            inputs.add(new TxContentUtxoInputs(txIO.getPaymentAddr().getBech32(), txContentOutputAmountList));
        }
        if (!inputs.isEmpty()) {
            txContentUtxo.setInputs(inputs);
        }
        ArrayList<TxContentUtxoOutputs> outputs = new ArrayList<TxContentUtxoOutputs>();
        for (TxIO txIO : txInfo.getOutputs()) {
            ArrayList<TxContentOutputAmount> txContentOutputAmountList = new ArrayList<TxContentOutputAmount>();
            if (txIO.getValue() != null && !txIO.getValue().isEmpty()) {
                txContentOutputAmountList.add(new TxContentOutputAmount("lovelace", txIO.getValue()));
            }
            for (Asset txAsset : txIO.getAssetList()) {
                txContentOutputAmountList.add(new TxContentOutputAmount(txAsset.getPolicyId() + txAsset.getAssetName(), txAsset.getQuantity()));
            }
            TxContentUtxoOutputs txContentUtxoOutputs = TxContentUtxoOutputs.builder().address(txIO.getPaymentAddr().getBech32()).amount(txContentOutputAmountList).dataHash(txIO.getDatumHash()).outputIndex(txIO.getTxIndex().intValue()).inlineDatum(txIO.getInlineDatum() != null ? txIO.getInlineDatum().getBytes() : null).referenceScriptHash(txIO.getReferenceScript() != null ? txIO.getReferenceScript().getHash() : null).build();
            outputs.add(txContentUtxoOutputs);
        }
        txContentUtxo.setOutputs(outputs);
        return Result.success((String)"OK").withValue((Object)txContentUtxo).code(200);
    }
}

