/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.backend.api.TransactionService;
import com.bloxbean.cardano.client.backend.api.UtxoService;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import rest.koios.client.backend.api.address.AddressService;
import rest.koios.client.backend.api.address.model.AddressInfo;
import rest.koios.client.backend.api.address.model.AddressUtxo;
import rest.koios.client.backend.api.base.common.Asset;

public class KoiosUtxoService
implements UtxoService {
    private final AddressService addressService;
    private final TransactionService transactionService;

    public KoiosUtxoService(AddressService addressService, TransactionService transactionService) {
        this.addressService = addressService;
        this.transactionService = transactionService;
    }

    public Result<List<Utxo>> getUtxos(String address, int count, int page) throws ApiException {
        return this.getUtxos(address, count, page, OrderEnum.desc);
    }

    public Result<List<Utxo>> getUtxos(String address, int count, int page, OrderEnum order) throws ApiException {
        try {
            if (page < 1) {
                return Result.success((String)"OK").withValue(Collections.emptyList()).code(200);
            }
            rest.koios.client.backend.api.base.Result addressInformationResult = this.addressService.getAddressInformation(address);
            if (!addressInformationResult.isSuccessful()) {
                return Result.error((String)addressInformationResult.getResponse()).withValue(Collections.emptyList()).code(addressInformationResult.getCode());
            }
            List<AddressUtxo> addressUtxos = ((AddressInfo)addressInformationResult.getValue()).getUtxoSet().stream().sorted(Comparator.comparingInt(AddressUtxo::getBlockTime).thenComparingInt(AddressUtxo::getTxIndex)).collect(Collectors.toList());
            if (order == OrderEnum.desc) {
                Collections.reverse(addressUtxos);
            }
            return this.convertToUTxOs(((AddressInfo)addressInformationResult.getValue()).getAddress(), KoiosUtxoService.getSubListByPage(addressUtxos, page, count));
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<List<Utxo>> getUtxos(String address, String unit, int count, int page) throws ApiException {
        return this.getUtxos(address, unit, count, page, OrderEnum.asc);
    }

    public Result<List<Utxo>> getUtxos(String address, String unit, int count, int page, OrderEnum order) throws ApiException {
        Result<List<Utxo>> resultUtxos = this.getUtxos(address, count, page, order);
        if (!resultUtxos.isSuccessful()) {
            return resultUtxos;
        }
        List utxos = (List)resultUtxos.getValue();
        if (utxos == null || utxos.isEmpty()) {
            return resultUtxos;
        }
        if (unit != null && !unit.isEmpty()) {
            utxos = utxos.stream().filter(utxo -> utxo.getAmount().stream().anyMatch(amount -> amount.getUnit().equals(unit))).collect(Collectors.toList());
        }
        if (!utxos.isEmpty()) {
            return Result.success((String)"OK").withValue((Object)utxos).code(200);
        }
        return Result.error((String)"Not Found").withValue(Collections.emptyList()).code(404);
    }

    public Result<Utxo> getTxOutput(String txHash, int outputIndex) throws ApiException {
        return this.transactionService.getTransactionOutput(txHash, outputIndex);
    }

    private Result<List<Utxo>> convertToUTxOs(String address, List<AddressUtxo> utxos) {
        ArrayList<Utxo> utxoList = new ArrayList<Utxo>();
        for (AddressUtxo addressUtxo : utxos) {
            Utxo utxo = new Utxo();
            utxo.setAddress(address);
            utxo.setTxHash(addressUtxo.getTxHash());
            utxo.setOutputIndex(addressUtxo.getTxIndex().intValue());
            utxo.setDataHash(addressUtxo.getDatumHash());
            if (addressUtxo.getInlineDatum() != null) {
                utxo.setInlineDatum(addressUtxo.getInlineDatum().getBytes());
            }
            if (addressUtxo.getReferenceScript() != null) {
                utxo.setReferenceScriptHash(addressUtxo.getReferenceScript().getHash());
            }
            ArrayList<Amount> amountList = new ArrayList<Amount>();
            amountList.add(new Amount("lovelace", new BigInteger(addressUtxo.getValue())));
            for (Asset asset : addressUtxo.getAssetList()) {
                String key = asset.getPolicyId() + asset.getAssetName();
                amountList.add(new Amount(key, new BigInteger(asset.getQuantity())));
            }
            utxo.setAmount(amountList);
            utxoList.add(utxo);
        }
        return Result.success((String)"OK").withValue(utxoList).code(200);
    }

    public static List<AddressUtxo> getSubListByPage(List<AddressUtxo> list, int pageNumber, int pageSize) {
        int start = 0;
        if (pageNumber > 0) {
            start = pageSize * (pageNumber - 1);
        } else if (pageNumber <= 0) {
            return Collections.emptyList();
        }
        int end = pageSize > 0 ? start + pageSize : start;
        if (list.size() < end + 1) {
            end = list.size();
        }
        if (end < start) {
            return Collections.emptyList();
        }
        return list.subList(start, end);
    }
}

