/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.model.AccountAddress;
import com.bloxbean.cardano.client.backend.model.AccountAsset;
import com.bloxbean.cardano.client.backend.model.AccountInformation;
import com.bloxbean.cardano.client.backend.model.AccountRewardsHistory;
import com.bloxbean.cardano.client.backend.model.AddressTransactionContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import rest.koios.client.backend.api.account.AccountService;
import rest.koios.client.backend.api.account.model.AccountHistory;
import rest.koios.client.backend.api.account.model.AccountHistoryInner;
import rest.koios.client.backend.api.account.model.AccountInfo;
import rest.koios.client.backend.api.account.model.AccountReward;
import rest.koios.client.backend.api.account.model.AccountRewards;
import rest.koios.client.backend.api.account.model.AccountTx;
import rest.koios.client.backend.factory.options.Limit;
import rest.koios.client.backend.factory.options.Offset;
import rest.koios.client.backend.factory.options.Option;
import rest.koios.client.backend.factory.options.Options;
import rest.koios.client.backend.factory.options.Order;
import rest.koios.client.backend.factory.options.SortType;
import rest.koios.client.backend.factory.options.filters.Filter;
import rest.koios.client.backend.factory.options.filters.FilterType;

public class KoiosAccountService
implements com.bloxbean.cardano.client.backend.api.AccountService {
    private final AccountService accountService;

    public KoiosAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public Result<AccountInformation> getAccountInformation(String stakeAddress) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result accountInformationResult = this.accountService.getAccountInformation(List.of(stakeAddress), Options.EMPTY);
            if (!accountInformationResult.isSuccessful()) {
                return Result.error((String)accountInformationResult.getResponse()).code(accountInformationResult.getCode());
            }
            if (((List)accountInformationResult.getValue()).isEmpty()) {
                return Result.error((String)"Not Found").code(404);
            }
            return this.convertToAccountInformation((AccountInfo)((List)accountInformationResult.getValue()).get(0));
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Result<AccountInformation> convertToAccountInformation(AccountInfo accountInfo) {
        AccountInformation accountInformation = new AccountInformation();
        accountInformation.setActive(Boolean.valueOf(accountInfo.getStatus().equals("registered")));
        accountInformation.setControlledAmount(accountInfo.getTotalBalance());
        accountInformation.setRewardsSum(accountInfo.getRewards());
        accountInformation.setWithdrawalsSum(accountInfo.getWithdrawals());
        accountInformation.setReservesSum(accountInfo.getReserves());
        accountInformation.setTreasurySum(accountInfo.getTreasury());
        accountInformation.setWithdrawableAmount(accountInfo.getRewardsAvailable());
        accountInformation.setPool_id(accountInfo.getDelegatedPool());
        return Result.success((String)"OK").withValue((Object)accountInformation).code(200);
    }

    public Result<List<AccountRewardsHistory>> getAccountRewardsHistory(String stakeAddress, int count, int page) throws ApiException {
        return this.getAccountRewardsHistory(stakeAddress, count, page, OrderEnum.asc);
    }

    public Result<List<AccountRewardsHistory>> getAccountRewardsHistory(String stakeAddress, int count, int page, OrderEnum order) throws ApiException {
        try {
            if (page != 1) {
                return Result.success((String)"OK").withValue(Collections.emptyList()).code(200);
            }
            rest.koios.client.backend.api.base.Result accountRewardsResult = this.accountService.getAccountRewards(List.of(stakeAddress), null, Options.EMPTY);
            if (!accountRewardsResult.isSuccessful()) {
                return Result.error((String)accountRewardsResult.getResponse()).code(accountRewardsResult.getCode());
            }
            if (((List)accountRewardsResult.getValue()).isEmpty()) {
                return Result.error((String)"Not Found").code(404);
            }
            return this.convertToAccountRewards(((AccountRewards)((List)accountRewardsResult.getValue()).get(0)).getRewards(), order);
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Result<List<AccountRewardsHistory>> convertToAccountRewards(List<AccountReward> accountRewardsList, OrderEnum order) {
        ArrayList<AccountRewardsHistory> accountRewardsHistories = new ArrayList<AccountRewardsHistory>();
        if (accountRewardsList != null) {
            accountRewardsList.forEach(accountRewards -> {
                AccountRewardsHistory accountRewardsHistory = new AccountRewardsHistory();
                accountRewardsHistory.setEpoch(accountRewards.getEarnedEpoch());
                accountRewardsHistory.setPoolId(accountRewards.getPoolId());
                accountRewardsHistory.setType(accountRewards.getType());
                accountRewardsHistory.setAmount(accountRewards.getAmount());
                accountRewardsHistories.add(accountRewardsHistory);
            });
        }
        if (order == OrderEnum.asc) {
            accountRewardsHistories.sort(Comparator.comparing(AccountRewardsHistory::getEpoch));
        } else {
            accountRewardsHistories.sort(Comparator.comparing(AccountRewardsHistory::getEpoch).reversed());
        }
        return Result.success((String)"OK").withValue(accountRewardsHistories).code(200);
    }

    public Result<List<com.bloxbean.cardano.client.backend.model.AccountHistory>> getAccountHistory(String stakeAddress, int count, int page) throws ApiException {
        return this.getAccountHistory(stakeAddress, count, page, OrderEnum.asc);
    }

    public Result<List<com.bloxbean.cardano.client.backend.model.AccountHistory>> getAccountHistory(String stakeAddress, int count, int page, OrderEnum order) throws ApiException {
        try {
            if (page != 1) {
                return Result.success((String)"OK").withValue(Collections.emptyList()).code(200);
            }
            rest.koios.client.backend.api.base.Result accountHistoriesResult = this.accountService.getAccountHistory(List.of(stakeAddress), null, Options.EMPTY);
            if (!accountHistoriesResult.isSuccessful()) {
                return Result.error((String)accountHistoriesResult.getResponse()).code(accountHistoriesResult.getCode());
            }
            if (((List)accountHistoriesResult.getValue()).isEmpty()) {
                return Result.error((String)"Not Found").code(404);
            }
            return this.convertToAccountHistories(((AccountHistory)((List)accountHistoriesResult.getValue()).get(0)).getHistory(), order);
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Result<List<com.bloxbean.cardano.client.backend.model.AccountHistory>> convertToAccountHistories(List<AccountHistoryInner> accountHistories, OrderEnum order) {
        ArrayList<com.bloxbean.cardano.client.backend.model.AccountHistory> accountHistoryList = new ArrayList<com.bloxbean.cardano.client.backend.model.AccountHistory>();
        if (accountHistories != null) {
            accountHistories.forEach(accountHistory -> {
                com.bloxbean.cardano.client.backend.model.AccountHistory accountHist = new com.bloxbean.cardano.client.backend.model.AccountHistory();
                accountHist.setAmount(accountHistory.getActiveStake());
                accountHist.setActiveEpoch(accountHistory.getEpochNo());
                accountHist.setPoolId(accountHistory.getPoolId());
                accountHistoryList.add(accountHist);
            });
        }
        if (order == OrderEnum.asc) {
            accountHistoryList.sort(Comparator.comparing(com.bloxbean.cardano.client.backend.model.AccountHistory::getActiveEpoch));
        } else {
            accountHistoryList.sort(Comparator.comparing(com.bloxbean.cardano.client.backend.model.AccountHistory::getActiveEpoch).reversed());
        }
        return Result.success((String)"OK").withValue(accountHistoryList).code(200);
    }

    public Result<List<AccountAddress>> getAllAccountAddresses(String stakeAddress) throws ApiException {
        ArrayList accountAddresses = new ArrayList();
        int page = 1;
        Result<List<AccountAddress>> accountAddressesResult = this.getAccountAddresses(stakeAddress, 1000, page);
        while (accountAddressesResult.isSuccessful()) {
            accountAddresses.addAll((Collection)accountAddressesResult.getValue());
            if (((List)accountAddressesResult.getValue()).size() != 1000) break;
            accountAddressesResult = this.getAccountAddresses(stakeAddress, 1000, ++page);
        }
        if (!accountAddressesResult.isSuccessful()) {
            return accountAddressesResult;
        }
        return Result.success((String)accountAddressesResult.toString()).withValue(accountAddresses).code(accountAddressesResult.code());
    }

    public Result<List<AccountAddress>> getAccountAddresses(String stakeAddress, int count, int page) throws ApiException {
        return this.getAccountAddresses(stakeAddress, count, page, OrderEnum.asc);
    }

    public Result<List<AccountAddress>> getAccountAddresses(String stakeAddress, int count, int page, OrderEnum order) throws ApiException {
        try {
            Options options = Options.builder().option((Option)Limit.of((long)count)).option((Option)Offset.of((long)((long)(page - 1) * (long)count))).build();
            rest.koios.client.backend.api.base.Result accountAddressesResult = this.accountService.getAccountAddresses(List.of(stakeAddress), false, true, options);
            if (!accountAddressesResult.isSuccessful()) {
                return Result.error((String)accountAddressesResult.getResponse()).code(accountAddressesResult.getCode());
            }
            if (((List)accountAddressesResult.getValue()).isEmpty()) {
                return Result.error((String)"Not Found").code(404);
            }
            return this.convertToAccountAddresses(((rest.koios.client.backend.api.account.model.AccountAddress)((List)accountAddressesResult.getValue()).get(0)).getAddresses());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Result<List<AccountAddress>> convertToAccountAddresses(List<String> accountAddressList) {
        ArrayList accountAddresses = new ArrayList();
        if (accountAddressList != null) {
            accountAddressList.forEach(accountAddress -> accountAddresses.add(new AccountAddress(accountAddress)));
        }
        return Result.success((String)"OK").withValue(accountAddresses).code(200);
    }

    public Result<List<AccountAsset>> getAllAccountAssets(String stakeAddress) throws ApiException {
        ArrayList accountAssets = new ArrayList();
        int page = 1;
        Result<List<AccountAsset>> accountAssetsResult = this.getAccountAssets(stakeAddress, 1000, page);
        while (accountAssetsResult.isSuccessful()) {
            accountAssets.addAll((Collection)accountAssetsResult.getValue());
            if (((List)accountAssetsResult.getValue()).size() != 1000) break;
            accountAssetsResult = this.getAccountAssets(stakeAddress, 1000, ++page);
        }
        if (!accountAssetsResult.isSuccessful()) {
            return accountAssetsResult;
        }
        return Result.success((String)accountAssetsResult.toString()).withValue(accountAssets).code(accountAssetsResult.code());
    }

    public Result<List<AccountAsset>> getAccountAssets(String stakeAddress, int count, int page) throws ApiException {
        return this.getAccountAssets(stakeAddress, count, page, OrderEnum.asc);
    }

    public Result<List<AccountAsset>> getAccountAssets(String stakeAddress, int count, int page, OrderEnum order) throws ApiException {
        try {
            Options options = Options.builder().option((Option)Limit.of((long)count)).option((Option)Offset.of((long)((long)(page - 1) * (long)count))).build();
            rest.koios.client.backend.api.base.Result accountAssetsResult = this.accountService.getAccountAssets(List.of(stakeAddress), null, options);
            if (!accountAssetsResult.isSuccessful()) {
                return Result.error((String)accountAssetsResult.getResponse()).code(accountAssetsResult.getCode());
            }
            if (((List)accountAssetsResult.getValue()).isEmpty()) {
                return Result.error((String)"Not Found").code(404);
            }
            return this.convertToAccountAssets((List)accountAssetsResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<List<AddressTransactionContent>> getAccountTransactions(String stakeAddress, int count, int page, OrderEnum order, Integer fromBlockHeight, Integer toBlockHeight) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result accountTxsResult;
            Options options = Options.builder().option((Option)Limit.of((long)count)).option((Option)Offset.of((long)((long)(page - 1) * (long)count))).build();
            if (order != null) {
                options.getOptionList().add(Order.by((String)"block_height", (SortType)(order == OrderEnum.asc ? SortType.ASC : SortType.DESC)));
            }
            if (toBlockHeight != null) {
                options.getOptionList().add(Filter.of((String)"block_height", (FilterType)FilterType.LTE, (String)toBlockHeight.toString()));
            }
            if (!(accountTxsResult = this.accountService.getAccountTxs(stakeAddress, fromBlockHeight, options)).isSuccessful()) {
                return Result.error((String)accountTxsResult.getResponse()).code(accountTxsResult.getCode());
            }
            if (((List)accountTxsResult.getValue()).isEmpty()) {
                return Result.error((String)"Not Found").code(404);
            }
            return this.convertToAddressTransactionContent((List)accountTxsResult.getValue(), order);
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<List<AddressTransactionContent>> getAllAccountTransactions(String stakeAddress, OrderEnum order, Integer fromBlockHeight, Integer toBlockHeight) throws ApiException {
        ArrayList addressTransactionContents = new ArrayList();
        int page = 1;
        Result<List<AddressTransactionContent>> addressTransactionsResult = this.getAccountTransactions(stakeAddress, 1000, page, order, fromBlockHeight, toBlockHeight);
        while (addressTransactionsResult.isSuccessful()) {
            addressTransactionContents.addAll((Collection)addressTransactionsResult.getValue());
            if (((List)addressTransactionsResult.getValue()).size() != 1000) break;
            addressTransactionsResult = this.getAccountTransactions(stakeAddress, 1000, ++page, order, fromBlockHeight, toBlockHeight);
        }
        if (!addressTransactionsResult.isSuccessful()) {
            return addressTransactionsResult;
        }
        return Result.success((String)addressTransactionsResult.toString()).withValue(addressTransactionContents).code(addressTransactionsResult.code());
    }

    private Result<List<AddressTransactionContent>> convertToAddressTransactionContent(List<AccountTx> accountTxs, OrderEnum order) {
        ArrayList<AddressTransactionContent> transactionContents = new ArrayList<AddressTransactionContent>();
        if (accountTxs != null) {
            accountTxs.forEach(accountTx -> {
                AddressTransactionContent transactionContent = new AddressTransactionContent();
                transactionContent.setTxHash(accountTx.getTxHash());
                transactionContent.setBlockHeight((long)accountTx.getBlockHeight().intValue());
                transactionContent.setBlockTime((long)accountTx.getBlockTime().intValue());
                transactionContents.add(transactionContent);
            });
        }
        Comparator<AddressTransactionContent> comparator = Comparator.comparing(AddressTransactionContent::getBlockHeight);
        if (order != OrderEnum.asc) {
            comparator = comparator.reversed();
        }
        transactionContents.sort(comparator);
        return Result.success((String)"OK").withValue(transactionContents).code(200);
    }

    private Result<List<AccountAsset>> convertToAccountAssets(List<rest.koios.client.backend.api.account.model.AccountAsset> accountAssetList) {
        ArrayList accountAssets = new ArrayList();
        if (accountAssetList != null) {
            accountAssetList.forEach(accountAsset -> {
                AccountAsset accountAsset1 = new AccountAsset();
                accountAsset1.setUnit(accountAsset.getPolicyId() + accountAsset.getAssetName());
                accountAsset1.setQuantity(accountAsset.getQuantity());
                accountAssets.add(accountAsset1);
            });
        }
        return Result.success((String)"OK").withValue(accountAssets).code(200);
    }
}

