/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.NetworkInfoService;
import com.bloxbean.cardano.client.backend.model.Genesis;
import java.math.BigDecimal;
import rest.koios.client.backend.api.base.exception.ApiException;
import rest.koios.client.backend.api.network.NetworkService;

public class KoiosNetworkService
implements NetworkInfoService {
    private final NetworkService networkService;

    public KoiosNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public Result<Genesis> getNetworkInfo() {
        try {
            rest.koios.client.backend.api.base.Result genesisInfoResult = this.networkService.getGenesisInfo();
            if (!genesisInfoResult.isSuccessful()) {
                return Result.error((String)genesisInfoResult.getResponse()).code(genesisInfoResult.getCode());
            }
            rest.koios.client.backend.api.network.model.Genesis gen = (rest.koios.client.backend.api.network.model.Genesis)genesisInfoResult.getValue();
            Genesis genesis = new Genesis();
            genesis.setActiveSlotsCoefficient(new BigDecimal(gen.getActiveslotcoeff()));
            genesis.setUpdateQuorum(Integer.valueOf(gen.getUpdatequorum()));
            genesis.setMaxLovelaceSupply(gen.getMaxlovelacesupply());
            genesis.setNetworkMagic(Integer.valueOf(gen.getNetworkmagic()));
            genesis.setEpochLength(Integer.valueOf(gen.getEpochlength()));
            genesis.setSystemStart(gen.getSystemstart());
            genesis.setSlotsPerKesPeriod(Integer.valueOf(gen.getSlotsperkesperiod()));
            genesis.setSlotLength(Integer.valueOf(gen.getSlotlength()));
            genesis.setMaxKesEvolutions(Integer.valueOf(gen.getMaxkesrevolutions()));
            genesis.setSecurityParam(Integer.valueOf(gen.getSecurityparam()));
            return Result.success((String)"OK").withValue((Object)genesis).code(200);
        }
        catch (ApiException e) {
            return Result.error((String)e.getMessage());
        }
    }
}

