/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.kupo;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.backend.api.UtxoService;
import com.bloxbean.cardano.client.backend.kupo.KupoBaseService;
import com.bloxbean.cardano.client.backend.kupo.http.MatchesApi;
import com.bloxbean.cardano.client.backend.kupo.model.KupoUtxo;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class KupoUtxoService
extends KupoBaseService
implements UtxoService {
    private MatchesApi matchesApi = (MatchesApi)this.getRetrofit().create(MatchesApi.class);

    public KupoUtxoService(String kupoBaseUrl) {
        super(kupoBaseUrl);
    }

    public Result<List<Utxo>> getUtxos(String address, int count, int page) throws ApiException {
        return this.getUtxos(address, page);
    }

    public Result<List<Utxo>> getUtxos(String address, int count, int page, OrderEnum order) throws ApiException {
        return this.getUtxos(address, page);
    }

    private Result getUtxos(String address, int page) throws ApiException {
        if (page != 1) {
            return Result.success((String)"OK").withValue(Collections.emptyList()).code(200);
        }
        Call<List<KupoUtxo>> utxosCall = this.matchesApi.getUnspentMatches(address);
        try {
            Response response = utxosCall.execute();
            if (response.isSuccessful()) {
                ArrayList utxos = new ArrayList();
                List kupoUtxos = (List)response.body();
                kupoUtxos.forEach(kupoUtxo -> {
                    Utxo utxo = new Utxo();
                    utxo.setTxHash(kupoUtxo.getTransactionId());
                    utxo.setOutputIndex(kupoUtxo.getOutputIndex());
                    utxo.setDataHash(kupoUtxo.getDataHash());
                    utxo.setReferenceScriptHash(kupoUtxo.getScriptHash());
                    ArrayList<Amount> amountList = new ArrayList<Amount>();
                    amountList.add(new Amount("lovelace", kupoUtxo.getValue().getCoins()));
                    Map<String, BigInteger> assets = kupoUtxo.getValue().getAssets();
                    assets.forEach((unit, value) -> {
                        unit = unit.replace(".", "");
                        Amount amount = new Amount(unit, value);
                        amountList.add(amount);
                    });
                    utxo.setAmount(amountList);
                    utxos.add(utxo);
                });
                return Result.success((String)"OK").withValue(utxos).code(200);
            }
            return Result.error((String)response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting utxos", (Exception)e);
        }
    }
}

