/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.ogmios;

import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.backend.api.AccountService;
import com.bloxbean.cardano.client.backend.api.AddressService;
import com.bloxbean.cardano.client.backend.api.AssetService;
import com.bloxbean.cardano.client.backend.api.BackendService;
import com.bloxbean.cardano.client.backend.api.BlockService;
import com.bloxbean.cardano.client.backend.api.EpochService;
import com.bloxbean.cardano.client.backend.api.MetadataService;
import com.bloxbean.cardano.client.backend.api.NetworkInfoService;
import com.bloxbean.cardano.client.backend.api.TransactionService;
import com.bloxbean.cardano.client.backend.api.UtxoService;
import com.bloxbean.cardano.client.backend.ogmios.OgmiosEpochService;
import com.bloxbean.cardano.client.backend.ogmios.OgmiosTransactionService;
import io.adabox.client.OgmiosWSClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;

public class OgmiosBackendService
implements BackendService {
    private final OgmiosWSClient wsClient;

    public OgmiosBackendService(String url) {
        try {
            this.wsClient = new OgmiosWSClient(new URI(url));
            if (url.startsWith("wss://")) {
                this.wsClient.setSocketFactory(SSLSocketFactory.getDefault());
            }
            this.wsClient.connectBlocking(20L, TimeUnit.SECONDS);
        }
        catch (URISyntaxException e) {
            throw new ApiRuntimeException("Invalid Ogmios URL: ", (Exception)e);
        }
        catch (InterruptedException e) {
            throw new ApiRuntimeException((Exception)e);
        }
    }

    public TransactionService getTransactionService() {
        return new OgmiosTransactionService(this.wsClient);
    }

    public AssetService getAssetService() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public BlockService getBlockService() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public NetworkInfoService getNetworkInfoService() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public UtxoService getUtxoService() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public AddressService getAddressService() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public AccountService getAccountService() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public EpochService getEpochService() {
        return new OgmiosEpochService(this.wsClient);
    }

    public MetadataService getMetadataService() {
        throw new UnsupportedOperationException("Not supported yet");
    }
}

