/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.kupo;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.backend.api.UtxoService;
import com.bloxbean.cardano.client.backend.kupo.KupoBaseService;
import com.bloxbean.cardano.client.backend.kupo.http.MatchesApi;
import com.bloxbean.cardano.client.backend.kupo.model.KupoDatum;
import com.bloxbean.cardano.client.backend.kupo.model.KupoUtxo;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class KupoUtxoService
extends KupoBaseService
implements UtxoService {
    private static final Logger log = LoggerFactory.getLogger(KupoUtxoService.class);
    public static final String DATUM_TYPE_INLINE = "inline";
    private MatchesApi matchesApi = (MatchesApi)this.getRetrofit().create(MatchesApi.class);

    public KupoUtxoService(String kupoBaseUrl) {
        super(kupoBaseUrl);
    }

    public Result<List<Utxo>> getUtxos(String address, int count, int page) throws ApiException {
        return this.getUtxos(address, page);
    }

    public Result<List<Utxo>> getUtxos(String address, int count, int page, OrderEnum order) throws ApiException {
        return this.getUtxos(address, page);
    }

    public Result<List<Utxo>> getUtxos(String address, String unit, int count, int page) throws ApiException {
        return this.getUtxos(address, unit, count, page, OrderEnum.asc);
    }

    public Result<List<Utxo>> getUtxos(String address, String unit, int count, int page, OrderEnum order) throws ApiException {
        Result<List<Utxo>> resultUtxos = this.getUtxos(address, count, page, order);
        if (!resultUtxos.isSuccessful()) {
            return resultUtxos;
        }
        List utxos = (List)resultUtxos.getValue();
        if (utxos == null || utxos.isEmpty()) {
            return resultUtxos;
        }
        List assetUtxos = utxos.stream().filter(utxo -> utxo.getAmount().stream().filter(amount -> amount.getUnit().equals(unit)).findFirst().isPresent()).collect(Collectors.toList());
        if (!assetUtxos.isEmpty()) {
            return Result.success((String)"OK").withValue(assetUtxos).code(200);
        }
        return Result.error((String)"Not Found").withValue(Collections.emptyList()).code(404);
    }

    public Result<Utxo> getTxOutput(String txHash, int outputIndex) throws ApiException {
        Call<List<KupoUtxo>> utxosCall = this.matchesApi.getMatches(outputIndex + "@" + txHash);
        try {
            Response response = utxosCall.execute();
            if (response.isSuccessful()) {
                List kupoUtxos = (List)response.body();
                if (kupoUtxos != null && kupoUtxos.size() > 0) {
                    KupoUtxo kupoUtxo = (KupoUtxo)kupoUtxos.get(0);
                    Utxo utxo = this.convertToUtxo(kupoUtxo);
                    return Result.success((String)"OK").withValue((Object)utxo).code(200);
                }
                return Result.error((String)"Not Found").withValue(null).code(404);
            }
            return Result.error(response.errorBody() != null ? response.errorBody().string() : null).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage());
        }
    }

    private Result getUtxos(String address, int page) throws ApiException {
        if (page != 1) {
            return Result.success((String)"OK").withValue(Collections.emptyList()).code(200);
        }
        Call<List<KupoUtxo>> utxosCall = this.matchesApi.getUnspentMatches(address);
        try {
            Response response = utxosCall.execute();
            if (response.isSuccessful()) {
                ArrayList utxos = new ArrayList();
                List kupoUtxos = (List)response.body();
                kupoUtxos.forEach(kupoUtxo -> {
                    Utxo utxo = this.convertToUtxo((KupoUtxo)kupoUtxo);
                    utxos.add(utxo);
                });
                return Result.success((String)"OK").withValue(utxos).code(200);
            }
            return Result.error(response.errorBody() != null ? response.errorBody().string() : null).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting utxos", (Exception)e);
        }
    }

    @NotNull
    private Utxo convertToUtxo(KupoUtxo kupoUtxo) {
        Utxo utxo = new Utxo();
        utxo.setTxHash(kupoUtxo.getTransactionId());
        utxo.setOutputIndex(kupoUtxo.getOutputIndex());
        utxo.setAddress(kupoUtxo.getAddress());
        utxo.setDataHash(kupoUtxo.getDatumHash());
        if (kupoUtxo.getDatumHash() != null && kupoUtxo.getDatumType().equals(DATUM_TYPE_INLINE)) {
            utxo.setInlineDatum(this.getDatum(kupoUtxo.getDatumHash()));
        }
        utxo.setReferenceScriptHash(kupoUtxo.getScriptHash());
        ArrayList<Amount> amountList = new ArrayList<Amount>();
        amountList.add(new Amount("lovelace", kupoUtxo.getValue().getCoins()));
        Map<String, BigInteger> assets = kupoUtxo.getValue().getAssets();
        assets.forEach((unit, value) -> {
            unit = unit.replace(".", "");
            Amount amount = new Amount(unit, value);
            amountList.add(amount);
        });
        utxo.setAmount(amountList);
        return utxo;
    }

    private String getDatum(String datumHash) {
        try {
            Call<KupoDatum> datumCall = this.matchesApi.getDatum(datumHash);
            Response datumResponse = datumCall.execute();
            if (datumResponse.isSuccessful()) {
                return ((KupoDatum)datumResponse.body()).getDatum();
            }
            return null;
        }
        catch (Exception e) {
            log.error("Datum not found for datum hash: " + datumHash);
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

