/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.ogmios;

import co.nstant.in.cbor.model.DataItem;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.EvaluationResult;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.TransactionService;
import com.bloxbean.cardano.client.backend.model.TransactionContent;
import com.bloxbean.cardano.client.backend.model.TxContentUtxo;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.util.HexUtil;
import io.adabox.client.OgmiosWSClient;
import io.adabox.model.tx.response.EvaluateTxResponse;
import io.adabox.model.tx.response.SubmitTxResponse;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgmiosTransactionService
implements TransactionService {
    private static final Logger log = LoggerFactory.getLogger(OgmiosTransactionService.class);
    private final OgmiosWSClient client;

    public OgmiosTransactionService(OgmiosWSClient client) {
        this.client = client;
    }

    public Result<String> submitTransaction(byte[] cborData) {
        SubmitTxResponse submitTxResponse = this.client.submitTx(cborData);
        if (submitTxResponse.getSubmitFail() == null) {
            String txHash = this.calculateTxHash(cborData);
            return Result.success((String)"OK").withValue((Object)txHash).code(200);
        }
        return Result.error((String)"FAILED").withValue((Object)submitTxResponse.getSubmitFail()).code(500);
    }

    public Result<TransactionContent> getTransaction(String txnHash) throws ApiException {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public Result<List<TransactionContent>> getTransactions(List<String> txnHashCollection) throws ApiException {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public Result<TxContentUtxo> getTransactionUtxos(String txnHash) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public Result<List<EvaluationResult>> evaluateTx(byte[] cborData) throws ApiException {
        EvaluateTxResponse evaluateTxResponse = this.client.evaluateTx(cborData);
        if (evaluateTxResponse.getEvaluationFailure() == null) {
            return Result.success((String)"OK").withValue((Object)evaluateTxResponse.getEvaluationResults()).code(200);
        }
        return Result.error((String)evaluateTxResponse.getEvaluationFailure().getErrorMsg()).withValue(Collections.emptyList()).code(500);
    }

    private String calculateTxHash(byte[] cbor) {
        try {
            Transaction transaction = Transaction.deserialize((byte[])cbor);
            return HexUtil.encodeHexString((byte[])Blake2bUtil.blake2bHash256((byte[])CborSerializationUtil.serialize((DataItem)transaction.getBody().serialize())));
        }
        catch (Exception e) {
            log.error("Unable to calculate transaction hash", (Throwable)e);
            return null;
        }
    }
}

