/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.kupo;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.backend.api.UtxoService;
import com.bloxbean.cardano.client.supplier.kupo.KupoUtxoSupplier;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KupoUtxoService
implements UtxoService {
    private static final Logger log = LoggerFactory.getLogger(KupoUtxoService.class);
    private final KupoUtxoSupplier kupoUtxoSupplier;

    public KupoUtxoService(String kupoBaseUrl) {
        this.kupoUtxoSupplier = new KupoUtxoSupplier(kupoBaseUrl);
    }

    public Result<List<Utxo>> getUtxos(String address, int count, int page) {
        List all = this.kupoUtxoSupplier.getPage(address, Integer.valueOf(count), Integer.valueOf(page), OrderEnum.asc);
        return Result.success((String)"OK").withValue((Object)all).code(200);
    }

    public Result<List<Utxo>> getUtxos(String address, int count, int page, OrderEnum order) {
        return this.getUtxos(address, count, page);
    }

    public Result<List<Utxo>> getUtxos(String address, String unit, int count, int page) {
        Result<List<Utxo>> resultUtxos = this.getUtxos(address, count, page);
        if (!resultUtxos.isSuccessful()) {
            return resultUtxos;
        }
        List utxos = (List)resultUtxos.getValue();
        if (utxos == null || utxos.isEmpty()) {
            return resultUtxos;
        }
        List assetUtxos = utxos.stream().filter(utxo -> utxo.getAmount().stream().filter(amount -> amount.getUnit().equals(unit)).findFirst().isPresent()).collect(Collectors.toList());
        if (!assetUtxos.isEmpty()) {
            return Result.success((String)"OK").withValue(assetUtxos).code(200);
        }
        return Result.error((String)"Not Found").withValue(Collections.emptyList()).code(404);
    }

    public Result<List<Utxo>> getUtxos(String address, String unit, int count, int page, OrderEnum order) {
        return this.getUtxos(address, unit, count, page);
    }

    public Result<Utxo> getTxOutput(String txHash, int outputIndex) {
        Optional txOutput = this.kupoUtxoSupplier.getTxOutput(txHash, outputIndex);
        if (txOutput.isPresent()) {
            return Result.success((String)"OK").withValue(txOutput.get()).code(200);
        }
        return Result.error((String)"Error getting utxo").withValue(null).code(404);
    }
}

