/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.ogmios.websocket;

import com.bloxbean.cardano.client.api.model.ProtocolParams;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.EpochService;
import com.bloxbean.cardano.client.backend.model.EpochContent;
import io.adabox.client.OgmiosWSClient;
import io.adabox.model.query.response.CurrentProtocolParameters;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ogmios5EpochService
implements EpochService {
    private static final Logger log = LoggerFactory.getLogger(Ogmios5EpochService.class);
    private final OgmiosWSClient client;

    public Ogmios5EpochService(OgmiosWSClient client) {
        this.client = client;
    }

    public Result<EpochContent> getLatestEpoch() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public Result<EpochContent> getEpoch(Integer epoch) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public Result<ProtocolParams> getProtocolParameters(Integer epoch) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public Result<ProtocolParams> getProtocolParameters() {
        CurrentProtocolParameters currentProtocolParameters = this.client.currentProtocolParameters();
        if (currentProtocolParameters != null && currentProtocolParameters.getFault() == null) {
            ProtocolParams protocolParams = this.copyProtocolParams(currentProtocolParameters);
            return Result.success((String)"OK").withValue((Object)protocolParams).code(200);
        }
        return Result.error((String)String.valueOf(currentProtocolParameters)).code(500);
    }

    private ProtocolParams copyProtocolParams(CurrentProtocolParameters currentProtocolParameters) {
        ProtocolParams protocolParams = new ProtocolParams();
        protocolParams.setMinFeeA(currentProtocolParameters.getProtocolParameters().getMinFeeCoefficient());
        protocolParams.setMinFeeB(currentProtocolParameters.getProtocolParameters().getMinFeeConstant());
        protocolParams.setMaxBlockSize(currentProtocolParameters.getProtocolParameters().getMaxBlockBodySize());
        protocolParams.setMaxTxSize(currentProtocolParameters.getProtocolParameters().getMaxTxSize());
        protocolParams.setMaxBlockHeaderSize(currentProtocolParameters.getProtocolParameters().getMaxBlockHeaderSize());
        protocolParams.setKeyDeposit(currentProtocolParameters.getProtocolParameters().getStakeKeyDeposit());
        protocolParams.setPoolDeposit(currentProtocolParameters.getProtocolParameters().getPoolDeposit());
        protocolParams.setEMax(currentProtocolParameters.getProtocolParameters().getPoolRetirementEpochBound());
        protocolParams.setNOpt(currentProtocolParameters.getProtocolParameters().getDesiredNumberOfPools());
        protocolParams.setA0(Ogmios5EpochService.stringToDecimal(currentProtocolParameters.getProtocolParameters().getPoolInfluence()));
        protocolParams.setRho(Ogmios5EpochService.stringToDecimal(currentProtocolParameters.getProtocolParameters().getMonetaryExpansion()));
        protocolParams.setTau(Ogmios5EpochService.stringToDecimal(currentProtocolParameters.getProtocolParameters().getTreasuryExpansion()));
        protocolParams.setDecentralisationParam(Ogmios5EpochService.stringToDecimal(currentProtocolParameters.getProtocolParameters().getDecentralizationParameter()));
        protocolParams.setExtraEntropy(currentProtocolParameters.getProtocolParameters().getExtraEntropy());
        protocolParams.setProtocolMajorVer(currentProtocolParameters.getProtocolParameters().getProtocolVersion().getMajor());
        protocolParams.setProtocolMinorVer(currentProtocolParameters.getProtocolParameters().getProtocolVersion().getMinor());
        protocolParams.setMinUtxo(currentProtocolParameters.getProtocolParameters().getMinUtxoValue());
        protocolParams.setMinPoolCost(currentProtocolParameters.getProtocolParameters().getMinPoolCost());
        LinkedHashMap plutusV1CostModel = (LinkedHashMap)currentProtocolParameters.getProtocolParameters().getCostModels().get((Object)"plutus:v1");
        LinkedHashMap plutusV2CostModel = (LinkedHashMap)currentProtocolParameters.getProtocolParameters().getCostModels().get((Object)"plutus:v2");
        LinkedHashMap<String, LinkedHashMap> costModels = new LinkedHashMap<String, LinkedHashMap>();
        costModels.put("PlutusV1", plutusV1CostModel);
        costModels.put("PlutusV2", plutusV2CostModel);
        protocolParams.setCostModels(costModels);
        protocolParams.setPriceMem(Ogmios5EpochService.stringToDecimal(currentProtocolParameters.getProtocolParameters().getPrices().getMemory()));
        protocolParams.setPriceStep(Ogmios5EpochService.stringToDecimal(currentProtocolParameters.getProtocolParameters().getPrices().getSteps()));
        protocolParams.setMaxTxExMem(currentProtocolParameters.getProtocolParameters().getMaxExecutionUnitsPerTransaction().getMemory());
        protocolParams.setMaxTxExSteps(currentProtocolParameters.getProtocolParameters().getMaxExecutionUnitsPerTransaction().getSteps());
        protocolParams.setMaxBlockExMem(currentProtocolParameters.getProtocolParameters().getMaxExecutionUnitsPerBlock().getMemory());
        protocolParams.setMaxBlockExSteps(currentProtocolParameters.getProtocolParameters().getMaxExecutionUnitsPerBlock().getSteps());
        protocolParams.setMaxValSize(currentProtocolParameters.getProtocolParameters().getMaxValueSize());
        protocolParams.setCollateralPercent(currentProtocolParameters.getProtocolParameters().getCollateralPercentage());
        protocolParams.setMaxCollateralInputs(currentProtocolParameters.getProtocolParameters().getMaxCollateralInputs());
        protocolParams.setCoinsPerUtxoSize(currentProtocolParameters.getProtocolParameters().getCoinsPerUtxoByte());
        protocolParams.setCoinsPerUtxoWord(currentProtocolParameters.getProtocolParameters().getCoinsPerUtxoWord());
        return protocolParams;
    }

    private static BigDecimal stringToDecimal(String str) {
        try {
            if (str == null || str.isEmpty()) {
                return null;
            }
            String[] parts = str.split("/");
            double d = Double.parseDouble(parts[0]) / Double.parseDouble(parts[1]);
            return new BigDecimal(d);
        }
        catch (Exception e) {
            log.error("Error in conversion", (Throwable)e);
            log.error("Error converting {} to BigDecimal", (Object)str);
            return BigDecimal.ZERO;
        }
    }
}

