/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AssetTransactionContent {
    private String txHash;
    private int txIndex;
    private long blockHeight;
    private long blockTime;

    public static AssetTransactionContentBuilder builder() {
        return new AssetTransactionContentBuilder();
    }

    public String getTxHash() {
        return this.txHash;
    }

    public int getTxIndex() {
        return this.txIndex;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public long getBlockTime() {
        return this.blockTime;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public void setTxIndex(int txIndex) {
        this.txIndex = txIndex;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public void setBlockTime(long blockTime) {
        this.blockTime = blockTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetTransactionContent)) {
            return false;
        }
        AssetTransactionContent other = (AssetTransactionContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTxIndex() != other.getTxIndex()) {
            return false;
        }
        if (this.getBlockHeight() != other.getBlockHeight()) {
            return false;
        }
        if (this.getBlockTime() != other.getBlockTime()) {
            return false;
        }
        String this$txHash = this.getTxHash();
        String other$txHash = other.getTxHash();
        return !(this$txHash == null ? other$txHash != null : !this$txHash.equals(other$txHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssetTransactionContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTxIndex();
        long $blockHeight = this.getBlockHeight();
        result = result * 59 + (int)($blockHeight >>> 32 ^ $blockHeight);
        long $blockTime = this.getBlockTime();
        result = result * 59 + (int)($blockTime >>> 32 ^ $blockTime);
        String $txHash = this.getTxHash();
        result = result * 59 + ($txHash == null ? 43 : $txHash.hashCode());
        return result;
    }

    public String toString() {
        return "AssetTransactionContent(txHash=" + this.getTxHash() + ", txIndex=" + this.getTxIndex() + ", blockHeight=" + this.getBlockHeight() + ", blockTime=" + this.getBlockTime() + ")";
    }

    public AssetTransactionContent() {
    }

    public AssetTransactionContent(String txHash, int txIndex, long blockHeight, long blockTime) {
        this.txHash = txHash;
        this.txIndex = txIndex;
        this.blockHeight = blockHeight;
        this.blockTime = blockTime;
    }

    public static class AssetTransactionContentBuilder {
        private String txHash;
        private int txIndex;
        private long blockHeight;
        private long blockTime;

        AssetTransactionContentBuilder() {
        }

        public AssetTransactionContentBuilder txHash(String txHash) {
            this.txHash = txHash;
            return this;
        }

        public AssetTransactionContentBuilder txIndex(int txIndex) {
            this.txIndex = txIndex;
            return this;
        }

        public AssetTransactionContentBuilder blockHeight(long blockHeight) {
            this.blockHeight = blockHeight;
            return this;
        }

        public AssetTransactionContentBuilder blockTime(long blockTime) {
            this.blockTime = blockTime;
            return this;
        }

        public AssetTransactionContent build() {
            return new AssetTransactionContent(this.txHash, this.txIndex, this.blockHeight, this.blockTime);
        }

        public String toString() {
            return "AssetTransactionContent.AssetTransactionContentBuilder(txHash=" + this.txHash + ", txIndex=" + this.txIndex + ", blockHeight=" + this.blockHeight + ", blockTime=" + this.blockTime + ")";
        }
    }
}

