/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.api;

import com.bloxbean.cardano.client.api.ScriptSupplier;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.ScriptService;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScriptSupplier
implements ScriptSupplier {
    private static final Logger log = LoggerFactory.getLogger(DefaultScriptSupplier.class);
    private ScriptService scriptService;

    public DefaultScriptSupplier(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public Optional<PlutusScript> getScript(String scriptHash) {
        if (scriptHash == null || scriptHash.isEmpty()) {
            return Optional.empty();
        }
        try {
            Result<PlutusScript> result = this.scriptService.getPlutusScript(scriptHash);
            if (result.isSuccessful()) {
                return Optional.of((PlutusScript)result.getValue());
            }
            log.debug("Error fetching script for hash: {}, {}", (Object)scriptHash, (Object)result.getResponse());
            return Optional.empty();
        }
        catch (ApiException e) {
            log.debug("Error fetching script for hash: {}", (Object)scriptHash, (Object)e);
            throw new ApiRuntimeException((Exception)((Object)e));
        }
    }
}

