/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.api;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.EvaluationResult;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.backend.model.TransactionContent;
import com.bloxbean.cardano.client.backend.model.TxContentRedeemers;
import com.bloxbean.cardano.client.backend.model.TxContentUtxo;
import com.bloxbean.cardano.client.backend.model.TxContentUtxoOutputs;
import com.bloxbean.cardano.client.util.JsonUtil;
import java.util.List;

public interface TransactionService {
    public Result<String> submitTransaction(byte[] var1) throws ApiException;

    public Result<TransactionContent> getTransaction(String var1) throws ApiException;

    public Result<List<TransactionContent>> getTransactions(List<String> var1) throws ApiException;

    public Result<TxContentUtxo> getTransactionUtxos(String var1) throws ApiException;

    public Result<List<TxContentRedeemers>> getTransactionRedeemers(String var1) throws ApiException;

    default public Result<Utxo> getTransactionOutput(String txnHash, int outputIndex) throws ApiException {
        Result<TxContentUtxo> result = this.getTransactionUtxos(txnHash);
        if (!result.isSuccessful()) {
            return Result.error((String)result.getResponse()).code(result.code());
        }
        TxContentUtxo txContentUtxo = (TxContentUtxo)result.getValue();
        if (txContentUtxo == null) {
            return Result.error((String)("No UTXO found for txHash: " + txnHash)).code(404);
        }
        List<TxContentUtxoOutputs> outputs = txContentUtxo.getOutputs();
        if (outputs == null) {
            return Result.error((String)("No UTXO found for txHash: " + txnHash)).code(404);
        }
        return outputs.stream().filter(output -> output.getOutputIndex() == outputIndex).findFirst().map(output -> {
            Utxo utxo = output.toUtxos(txnHash);
            return Result.success((String)JsonUtil.getPrettyJson((Object)utxo)).withValue((Object)utxo).code(result.code());
        }).orElseGet(() -> Result.error((String)("No UTXO found for txHash: " + txnHash + ", outputIndex: " + outputIndex)).code(404));
    }

    default public Result<List<EvaluationResult>> evaluateTx(byte[] cborData) throws ApiException {
        throw new UnsupportedOperationException("Not yet supported");
    }
}

