/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.model;

import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.backend.model.TxContentOutputAmount;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class TxContentUtxoOutputs {
    private String address;
    private List<TxContentOutputAmount> amount;
    private int outputIndex;
    private String dataHash;
    private String inlineDatum;
    private String referenceScriptHash;

    public Utxo toUtxos(String txHash) {
        Utxo utxo = new Utxo();
        utxo.setAddress(this.getAddress());
        utxo.setTxHash(txHash);
        List amounts = this.getAmount() != null ? this.getAmount().stream().map(amount -> new Amount(amount.getUnit(), new BigInteger(amount.getQuantity()))).collect(Collectors.toList()) : Collections.emptyList();
        utxo.setAmount(amounts);
        utxo.setOutputIndex(this.getOutputIndex());
        utxo.setDataHash(this.getDataHash());
        utxo.setInlineDatum(this.getInlineDatum());
        utxo.setReferenceScriptHash(this.getReferenceScriptHash());
        return utxo;
    }

    private static List<TxContentOutputAmount> $default$amount() {
        return new ArrayList<TxContentOutputAmount>();
    }

    public static TxContentUtxoOutputsBuilder builder() {
        return new TxContentUtxoOutputsBuilder();
    }

    public String getAddress() {
        return this.address;
    }

    public List<TxContentOutputAmount> getAmount() {
        return this.amount;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public String getDataHash() {
        return this.dataHash;
    }

    public String getInlineDatum() {
        return this.inlineDatum;
    }

    public String getReferenceScriptHash() {
        return this.referenceScriptHash;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setAmount(List<TxContentOutputAmount> amount) {
        this.amount = amount;
    }

    public void setOutputIndex(int outputIndex) {
        this.outputIndex = outputIndex;
    }

    public void setDataHash(String dataHash) {
        this.dataHash = dataHash;
    }

    public void setInlineDatum(String inlineDatum) {
        this.inlineDatum = inlineDatum;
    }

    public void setReferenceScriptHash(String referenceScriptHash) {
        this.referenceScriptHash = referenceScriptHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxContentUtxoOutputs)) {
            return false;
        }
        TxContentUtxoOutputs other = (TxContentUtxoOutputs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOutputIndex() != other.getOutputIndex()) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        List<TxContentOutputAmount> this$amount = this.getAmount();
        List<TxContentOutputAmount> other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$dataHash = this.getDataHash();
        String other$dataHash = other.getDataHash();
        if (this$dataHash == null ? other$dataHash != null : !this$dataHash.equals(other$dataHash)) {
            return false;
        }
        String this$inlineDatum = this.getInlineDatum();
        String other$inlineDatum = other.getInlineDatum();
        if (this$inlineDatum == null ? other$inlineDatum != null : !this$inlineDatum.equals(other$inlineDatum)) {
            return false;
        }
        String this$referenceScriptHash = this.getReferenceScriptHash();
        String other$referenceScriptHash = other.getReferenceScriptHash();
        return !(this$referenceScriptHash == null ? other$referenceScriptHash != null : !this$referenceScriptHash.equals(other$referenceScriptHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TxContentUtxoOutputs;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOutputIndex();
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        List<TxContentOutputAmount> $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $dataHash = this.getDataHash();
        result = result * 59 + ($dataHash == null ? 43 : $dataHash.hashCode());
        String $inlineDatum = this.getInlineDatum();
        result = result * 59 + ($inlineDatum == null ? 43 : $inlineDatum.hashCode());
        String $referenceScriptHash = this.getReferenceScriptHash();
        result = result * 59 + ($referenceScriptHash == null ? 43 : $referenceScriptHash.hashCode());
        return result;
    }

    public String toString() {
        return "TxContentUtxoOutputs(address=" + this.getAddress() + ", amount=" + this.getAmount() + ", outputIndex=" + this.getOutputIndex() + ", dataHash=" + this.getDataHash() + ", inlineDatum=" + this.getInlineDatum() + ", referenceScriptHash=" + this.getReferenceScriptHash() + ")";
    }

    public TxContentUtxoOutputs() {
        this.amount = TxContentUtxoOutputs.$default$amount();
    }

    public TxContentUtxoOutputs(String address, List<TxContentOutputAmount> amount, int outputIndex, String dataHash, String inlineDatum, String referenceScriptHash) {
        this.address = address;
        this.amount = amount;
        this.outputIndex = outputIndex;
        this.dataHash = dataHash;
        this.inlineDatum = inlineDatum;
        this.referenceScriptHash = referenceScriptHash;
    }

    public static class TxContentUtxoOutputsBuilder {
        private String address;
        private boolean amount$set;
        private List<TxContentOutputAmount> amount$value;
        private int outputIndex;
        private String dataHash;
        private String inlineDatum;
        private String referenceScriptHash;

        TxContentUtxoOutputsBuilder() {
        }

        public TxContentUtxoOutputsBuilder address(String address) {
            this.address = address;
            return this;
        }

        public TxContentUtxoOutputsBuilder amount(List<TxContentOutputAmount> amount) {
            this.amount$value = amount;
            this.amount$set = true;
            return this;
        }

        public TxContentUtxoOutputsBuilder outputIndex(int outputIndex) {
            this.outputIndex = outputIndex;
            return this;
        }

        public TxContentUtxoOutputsBuilder dataHash(String dataHash) {
            this.dataHash = dataHash;
            return this;
        }

        public TxContentUtxoOutputsBuilder inlineDatum(String inlineDatum) {
            this.inlineDatum = inlineDatum;
            return this;
        }

        public TxContentUtxoOutputsBuilder referenceScriptHash(String referenceScriptHash) {
            this.referenceScriptHash = referenceScriptHash;
            return this;
        }

        public TxContentUtxoOutputs build() {
            List<TxContentOutputAmount> amount$value = this.amount$value;
            if (!this.amount$set) {
                amount$value = TxContentUtxoOutputs.$default$amount();
            }
            return new TxContentUtxoOutputs(this.address, amount$value, this.outputIndex, this.dataHash, this.inlineDatum, this.referenceScriptHash);
        }

        public String toString() {
            return "TxContentUtxoOutputs.TxContentUtxoOutputsBuilder(address=" + this.address + ", amount$value=" + this.amount$value + ", outputIndex=" + this.outputIndex + ", dataHash=" + this.dataHash + ", inlineDatum=" + this.inlineDatum + ", referenceScriptHash=" + this.referenceScriptHash + ")";
        }
    }
}

