/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.api;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.backend.api.UtxoService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUtxoSupplier
implements UtxoSupplier {
    private static final Logger log = LoggerFactory.getLogger(DefaultUtxoSupplier.class);
    private final UtxoService utxoService;
    private boolean searchByAddressVkh;

    public DefaultUtxoSupplier(UtxoService utxoService) {
        this.utxoService = utxoService;
    }

    public List<Utxo> getPage(String address, Integer nrOfItems, Integer page, OrderEnum order) {
        String searchKey = address;
        if (this.searchByAddressVkh) {
            Address addr = new Address(address);
            if (addr != null) {
                searchKey = addr.getBech32VerificationKeyHash().orElse(null);
            } else {
                log.warn("searchByAddressVkh is true, but no payment credential found for the address {}.", (Object)address);
            }
        }
        try {
            Result<List<Utxo>> result = this.utxoService.getUtxos(searchKey, nrOfItems != null ? nrOfItems : 100, page != null ? page + 1 : 1, order);
            return result != null && result.getValue() != null ? (List)result.getValue() : Collections.emptyList();
        }
        catch (ApiException e) {
            throw new ApiRuntimeException((Exception)((Object)e));
        }
    }

    public Optional<Utxo> getTxOutput(String txHash, int outputIndex) {
        try {
            Result<Utxo> result = this.utxoService.getTxOutput(txHash, outputIndex);
            return result != null && result.getValue() != null ? Optional.of((Utxo)result.getValue()) : Optional.empty();
        }
        catch (ApiException e) {
            throw new ApiRuntimeException((Exception)((Object)e));
        }
    }

    public boolean isUsedAddress(Address address) {
        try {
            return this.utxoService.isUsedAddress(address.toBech32());
        }
        catch (ApiException e) {
            throw new ApiRuntimeException((Exception)((Object)e));
        }
    }

    public void setSearchByAddressVkh(boolean flag) {
        this.searchByAddressVkh = flag;
    }
}

