/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.api;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.model.ScriptDatum;
import com.bloxbean.cardano.client.backend.model.ScriptDatumCbor;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.plutus.util.PlutusUtil;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import com.bloxbean.cardano.client.util.JsonUtil;
import com.fasterxml.jackson.databind.JsonNode;

public interface ScriptService {
    public Result<ScriptDatum> getScriptDatum(String var1) throws ApiException;

    public Result<ScriptDatumCbor> getScriptDatumCbor(String var1) throws ApiException;

    public Result<JsonNode> getNativeScriptJson(String var1) throws ApiException;

    public Result<String> getPlutusScriptCbor(String var1) throws ApiException;

    default public Result<NativeScript> getNativeScript(String scriptHash) throws ApiException {
        Result<JsonNode> contentResult = this.getNativeScriptJson(scriptHash);
        if (!contentResult.isSuccessful()) {
            return Result.error((String)contentResult.getResponse()).code(contentResult.code());
        }
        try {
            NativeScript script = NativeScript.deserialize((JsonNode)((JsonNode)contentResult.getValue()));
            return Result.success((String)JsonUtil.getPrettyJson((Object)script)).withValue((Object)script);
        }
        catch (CborDeserializationException e) {
            throw new ApiException("Error deserializing native script content " + String.valueOf(contentResult.getValue()), (Exception)((Object)e));
        }
    }

    default public Result<PlutusScript> getPlutusScript(String scriptHash) throws ApiException {
        Result<String> cborResult = this.getPlutusScriptCbor(scriptHash);
        if (!cborResult.isSuccessful()) {
            return Result.error((String)cborResult.getResponse()).code(cborResult.code());
        }
        try {
            return PlutusUtil.getPlutusScript((String)scriptHash, (String)((String)cborResult.getValue())).map(script -> Result.success((String)JsonUtil.getPrettyJson((Object)script)).withValue(script)).orElse(Result.error((String)("Error getting plutus script for hash: " + scriptHash)));
        }
        catch (Exception e) {
            throw new ApiException("Error getting plutus script" + (String)cborResult.getValue(), e);
        }
    }
}

