/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AddressTransactionContent {
    private String txHash;
    private int txIndex;
    private long blockHeight;
    private long blockTime;

    public static AddressTransactionContentBuilder builder() {
        return new AddressTransactionContentBuilder();
    }

    public String getTxHash() {
        return this.txHash;
    }

    public int getTxIndex() {
        return this.txIndex;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public long getBlockTime() {
        return this.blockTime;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public void setTxIndex(int txIndex) {
        this.txIndex = txIndex;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public void setBlockTime(long blockTime) {
        this.blockTime = blockTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddressTransactionContent)) {
            return false;
        }
        AddressTransactionContent other = (AddressTransactionContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTxIndex() != other.getTxIndex()) {
            return false;
        }
        if (this.getBlockHeight() != other.getBlockHeight()) {
            return false;
        }
        if (this.getBlockTime() != other.getBlockTime()) {
            return false;
        }
        String this$txHash = this.getTxHash();
        String other$txHash = other.getTxHash();
        return !(this$txHash == null ? other$txHash != null : !this$txHash.equals(other$txHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddressTransactionContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTxIndex();
        long $blockHeight = this.getBlockHeight();
        result = result * 59 + (int)($blockHeight >>> 32 ^ $blockHeight);
        long $blockTime = this.getBlockTime();
        result = result * 59 + (int)($blockTime >>> 32 ^ $blockTime);
        String $txHash = this.getTxHash();
        result = result * 59 + ($txHash == null ? 43 : $txHash.hashCode());
        return result;
    }

    public String toString() {
        return "AddressTransactionContent(txHash=" + this.getTxHash() + ", txIndex=" + this.getTxIndex() + ", blockHeight=" + this.getBlockHeight() + ", blockTime=" + this.getBlockTime() + ")";
    }

    public AddressTransactionContent() {
    }

    public AddressTransactionContent(String txHash, int txIndex, long blockHeight, long blockTime) {
        this.txHash = txHash;
        this.txIndex = txIndex;
        this.blockHeight = blockHeight;
        this.blockTime = blockTime;
    }

    public static class AddressTransactionContentBuilder {
        private String txHash;
        private int txIndex;
        private long blockHeight;
        private long blockTime;

        AddressTransactionContentBuilder() {
        }

        public AddressTransactionContentBuilder txHash(String txHash) {
            this.txHash = txHash;
            return this;
        }

        public AddressTransactionContentBuilder txIndex(int txIndex) {
            this.txIndex = txIndex;
            return this;
        }

        public AddressTransactionContentBuilder blockHeight(long blockHeight) {
            this.blockHeight = blockHeight;
            return this;
        }

        public AddressTransactionContentBuilder blockTime(long blockTime) {
            this.blockTime = blockTime;
            return this;
        }

        public AddressTransactionContent build() {
            return new AddressTransactionContent(this.txHash, this.txIndex, this.blockHeight, this.blockTime);
        }

        public String toString() {
            return "AddressTransactionContent.AddressTransactionContentBuilder(txHash=" + this.txHash + ", txIndex=" + this.txIndex + ", blockHeight=" + this.blockHeight + ", blockTime=" + this.blockTime + ")";
        }
    }
}

