/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip20;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnicodeString;
import com.bloxbean.cardano.client.metadata.MetadataList;
import com.bloxbean.cardano.client.metadata.MetadataMap;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadata;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataList;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataMap;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageMetadata
extends CBORMetadata {
    private static final Logger log = LoggerFactory.getLogger(MessageMetadata.class);
    private static final int label = 674;
    @JsonIgnore
    private final CBORMetadataMap map = new CBORMetadataMap();
    @JsonIgnore
    private final CBORMetadataList messageList = new CBORMetadataList();

    private MessageMetadata() {
        this.map.put("msg", (MetadataList)this.messageList);
        this.put(BigInteger.valueOf(674L), (MetadataMap)this.map);
    }

    public static MessageMetadata create() {
        return new MessageMetadata();
    }

    public MessageMetadata add(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        int len = message.getBytes(StandardCharsets.UTF_8).length;
        if (len > 64) {
            if (log.isDebugEnabled()) {
                log.debug("Message : " + message);
            }
            throw new IllegalArgumentException("Each message should have a maximum length of 64 characters. But actual length is : " + len);
        }
        this.messageList.add(message);
        return this;
    }

    public List<String> getMessages() {
        Array array = this.messageList.getArray();
        if (array == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> messages = new ArrayList<String>();
        for (DataItem di : array.getDataItems()) {
            if (di instanceof UnicodeString) {
                messages.add(((UnicodeString)di).getString());
                continue;
            }
            throw new IllegalArgumentException("Invalid data found in the array : " + di);
        }
        return messages;
    }
}

