/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip25;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import com.bloxbean.cardano.client.cip.cip25.NFTMetadataUtil;
import com.bloxbean.cardano.client.cip.cip25.NFTProperties;
import com.bloxbean.cardano.client.metadata.MetadataList;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataList;
import com.bloxbean.cardano.client.metadata.cbor.MetadataHelper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class NFTFile
extends NFTProperties {
    public static final String NAME_KEY = "name";
    public static final String MEDIA_TYPE_KEY = "mediaType";
    public static final String SRC_KEY = "src";

    private NFTFile() {
    }

    private NFTFile(Map map) {
        super(map);
    }

    public static NFTFile create() {
        return new NFTFile();
    }

    public static NFTFile create(Map map) {
        return new NFTFile(map);
    }

    public NFTFile name(String name) {
        this.put(NAME_KEY, name);
        return this;
    }

    public String getName() {
        return (String)this.get(NAME_KEY);
    }

    public NFTFile mediaType(String mediaType) {
        this.put(MEDIA_TYPE_KEY, mediaType);
        return this;
    }

    public String getMediaType() {
        return (String)this.get(MEDIA_TYPE_KEY);
    }

    public NFTFile src(String uri) {
        NFTMetadataUtil.addSingleOrMultipleValue(this, SRC_KEY, uri);
        return this;
    }

    public NFTFile setsrcs(List<String> uris) {
        if (uris == null || uris.size() == 0) {
            return this;
        }
        CBORMetadataList list = new CBORMetadataList();
        for (String uri : uris) {
            list.add(uri);
        }
        this.put(SRC_KEY, (MetadataList)list);
        return this;
    }

    public List<String> getSrcs() {
        Object value = this.get(SRC_KEY);
        if (value instanceof String) {
            return Arrays.asList((String)value);
        }
        if (value instanceof CBORMetadataList) {
            Array array = ((CBORMetadataList)value).getArray();
            return array.getDataItems().stream().map(di -> (String)MetadataHelper.extractActualValue((DataItem)di)).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public NFTFile property(String name, String value) {
        return (NFTFile)super.property(name, value);
    }

    @Override
    public NFTFile property(String name, java.util.Map<String, Object> values) {
        return (NFTFile)super.property(name, values);
    }

    @Override
    public NFTFile property(String name, List<String> values) {
        return (NFTFile)super.property(name, values);
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

