/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip27;

import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import com.bloxbean.cardano.client.cip.cip25.NFTProperties;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataList;

public class RoyaltyToken
extends NFTProperties {
    public static final String ADDRESS_KEY = "addr";
    public static final String RATE_KEY = "rate";

    private RoyaltyToken() {
    }

    private RoyaltyToken(Map map) {
        super(map);
    }

    public static RoyaltyToken create() {
        return new RoyaltyToken();
    }

    static RoyaltyToken create(Map map) {
        return new RoyaltyToken(map);
    }

    public RoyaltyToken address(String address) {
        this.put(ADDRESS_KEY, address);
        return this;
    }

    public RoyaltyToken rate(Double rate) {
        if (rate < 0.0 || rate > 1.0) {
            throw new IllegalArgumentException("Royalty Rate is Outside of Legal Range (0.0-1.0)");
        }
        this.put(RATE_KEY, rate.toString());
        return this;
    }

    public String getAddress() {
        if (this.get(ADDRESS_KEY) instanceof CBORMetadataList) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DataItem dataItem : ((CBORMetadataList)this.get(ADDRESS_KEY)).getArray().getDataItems()) {
                stringBuilder.append(dataItem.toString());
            }
            return stringBuilder.toString();
        }
        return (String)this.get(ADDRESS_KEY);
    }

    public Double getRate() {
        return Double.valueOf((String)this.get(RATE_KEY));
    }
}

