/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip30;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.api.util.ValueUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.util.HexUtil;
import java.util.List;

class CIP30UtxoDeserializer {
    CIP30UtxoDeserializer() {
    }

    public static Utxo deserialize(byte[] bytes) throws CborDeserializationException {
        Utxo utxo = new Utxo();
        try {
            List dataItemList = CborDecoder.decode((byte[])bytes);
            if (dataItemList.size() != 1) {
                throw new CborDeserializationException("Invalid no of items");
            }
            Array array = (Array)dataItemList.get(0);
            List utxoItems = array.getDataItems();
            if (utxoItems.size() < 2) {
                throw new CborDeserializationException("Invalid no of items");
            }
            Array txArray = (Array)utxoItems.get(0);
            List txDataItems = txArray.getDataItems();
            if (txDataItems.size() < 2) {
                throw new CborDeserializationException("Invalid no of items");
            }
            utxo.setTxHash(HexUtil.encodeHexString((byte[])((ByteString)txDataItems.get(0)).getBytes()));
            utxo.setOutputIndex(((UnsignedInteger)txDataItems.get(1)).getValue().intValue());
            TransactionOutput transactionOutput = TransactionOutput.deserialize((DataItem)((DataItem)utxoItems.get(1)));
            utxo.setAddress(transactionOutput.getAddress());
            utxo.setAmount(ValueUtil.toAmountList((Value)transactionOutput.getValue()));
            if (transactionOutput.getInlineDatum() != null) {
                utxo.setInlineDatum(transactionOutput.getInlineDatum().serializeToHex());
            }
            if (transactionOutput.getDatumHash() != null) {
                utxo.setDataHash(HexUtil.encodeHexString((byte[])transactionOutput.getDatumHash()));
            }
            if (transactionOutput.getScriptRef() != null) {
                utxo.setReferenceScriptHash(HexUtil.encodeHexString((byte[])transactionOutput.getScriptRef()));
            }
            return utxo;
        }
        catch (Exception e) {
            throw new CborDeserializationException("CBOR deserialization failed", e);
        }
    }
}

