/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip30;

import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.cip.cip30.CIP30UtxoDeserializer;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.util.HexUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class CIP30UtxoSupplier
implements UtxoSupplier {
    private final List<Utxo> utxos = new ArrayList<Utxo>();

    public CIP30UtxoSupplier(List<String> hexEncodedCborUtxos) throws CborDeserializationException {
        for (String cbor : hexEncodedCborUtxos) {
            this.utxos.add(CIP30UtxoDeserializer.deserialize(HexUtil.decodeHexString((String)cbor)));
        }
    }

    public List<Utxo> getPage(String address, Integer pageSize, Integer page, OrderEnum order) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Invalid page size: " + pageSize);
        }
        if (page < 0) {
            throw new IllegalArgumentException("Invalid page number: " + page);
        }
        int fromIndex = page * pageSize;
        if (this.utxos.size() <= fromIndex) {
            return Collections.emptyList();
        }
        return this.utxos.subList(fromIndex, Math.min(fromIndex + pageSize, this.utxos.size()));
    }

    public Optional<Utxo> getTxOutput(String txHash, int outputIndex) {
        return this.utxos.stream().filter(utxo -> utxo.getTxHash().equals(txHash) && utxo.getOutputIndex() == outputIndex).findFirst();
    }

    public List<Utxo> getAll(String paymentAddress) {
        return this.utxos;
    }
}

