/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip67;

import com.bloxbean.cardano.client.crypto.CRC8;
import com.bloxbean.cardano.client.crypto.Utils;
import java.nio.ByteBuffer;

public class CIP67AssetNameUtil {
    private CIP67AssetNameUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static byte[] labelToPrefix(int label) {
        byte[] labelBytes = new byte[4];
        Utils.uint32ToByteArrayBE((long)label, (byte[])labelBytes, (int)0);
        int crc = CRC8.applyCRC8((byte[])labelBytes);
        int prefix = 1;
        prefix = label << 12;
        byte[] prefixBytes = new byte[4];
        Utils.uint32ToByteArrayBE((long)(prefix += crc << 4), (byte[])prefixBytes, (int)0);
        return prefixBytes;
    }

    public static int prefixToLabel(byte[] labelBytes) {
        int assetName = ByteBuffer.wrap(labelBytes).getInt();
        int labelNum = assetName >> 12;
        return labelNum &= 0x3FFFFFF;
    }

    public static boolean isValidAssetName(int assetName) {
        return CIP67AssetNameUtil.isValidPadding(assetName) && CIP67AssetNameUtil.verifyCheckSum(assetName);
    }

    public static boolean isValidAssetName(byte[] assetName) {
        int assetNameAsInt = (int)Utils.readUint32BE((byte[])assetName, (int)0);
        return CIP67AssetNameUtil.isValidPadding(assetNameAsInt) && CIP67AssetNameUtil.verifyCheckSum(assetNameAsInt);
    }

    private static boolean isValidPadding(int assetName) {
        return (assetName & 0xC000003) == 0;
    }

    private static boolean verifyCheckSum(int assetName) {
        byte[] assetNamesAsBytes = new byte[4];
        Utils.uint32ToByteArrayBE((long)assetName, (byte[])assetNamesAsBytes, (int)0);
        int label = CIP67AssetNameUtil.prefixToLabel(assetNamesAsBytes);
        int checkSum = CIP67AssetNameUtil.getCheckSum(assetNamesAsBytes);
        byte[] labelAsBytes = new byte[4];
        Utils.uint32ToByteArrayBE((long)label, (byte[])labelAsBytes, (int)0);
        return checkSum == CRC8.applyCRC8((byte[])labelAsBytes);
    }

    private static int getCheckSum(byte[] labelBytes) {
        int assetName = ByteBuffer.wrap(labelBytes).getInt();
        byte[] shiftedAssetNameBytes = new byte[4];
        Utils.uint32ToByteArrayBE((long)(assetName >>= 4), (byte[])shiftedAssetNameBytes, (int)0);
        return shiftedAssetNameBytes[3];
    }
}

