/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip68;

import com.bloxbean.cardano.client.cip.cip68.common.CIP68Datum;
import com.bloxbean.cardano.client.cip.cip68.common.CIP68TokenTemplate;
import com.bloxbean.cardano.client.cip.cip68.common.CIP68Util;
import com.bloxbean.cardano.client.plutus.spec.BigIntPlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;

public class CIP68FT
extends CIP68TokenTemplate<CIP68FT> {
    private static final int ASSET_NAME_LABEL = 333;
    private static final String TICKER_KEY = "ticker";
    private static final String URL_KEY = "url";
    private static final String DECIMALS_KEY = "decimals";
    private static final String LOGO_KEY = "logo";

    private CIP68FT() {
        super(333);
    }

    private CIP68FT(CIP68Datum cip68Datum) {
        super(333, cip68Datum);
    }

    public static CIP68FT create() {
        return new CIP68FT();
    }

    public CIP68FT ticker(String ticker) {
        this.property(TICKER_KEY, ticker);
        return this;
    }

    public String getTicker() {
        return this.getStringProperty(TICKER_KEY);
    }

    public CIP68FT url(String url) {
        this.property(URL_KEY, url);
        return this;
    }

    public String getURL() {
        return this.getStringProperty(URL_KEY);
    }

    public CIP68FT decimals(int decimals) {
        this.property((PlutusData)CIP68Util.toByteString(DECIMALS_KEY), (PlutusData)BigIntPlutusData.of((int)decimals));
        return this;
    }

    public int getDecimals() {
        return ((BigIntPlutusData)this.getProperty((PlutusData)CIP68Util.toByteString(DECIMALS_KEY))).getValue().intValue();
    }

    public CIP68FT logo(String logo) {
        this.property(LOGO_KEY, logo);
        return this;
    }

    public String getLogo() {
        return this.getStringProperty(LOGO_KEY);
    }

    public static CIP68FT fromDatum(byte[] datumBytes) {
        CIP68FT token = CIP68FT.create();
        return (CIP68FT)token.populateFromDatumBytes(datumBytes);
    }
}

