/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip68;

import com.bloxbean.cardano.client.cip.cip68.common.CIP68Datum;
import com.bloxbean.cardano.client.cip.cip68.common.CIP68File;
import com.bloxbean.cardano.client.cip.cip68.common.CIP68TokenTemplate;
import com.bloxbean.cardano.client.cip.cip68.common.CIP68Util;
import com.bloxbean.cardano.client.plutus.spec.ListPlutusData;
import com.bloxbean.cardano.client.plutus.spec.MapPlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class CIP68NFT
extends CIP68TokenTemplate<CIP68NFT> {
    private static final int ASSET_NAME_LABEL = 222;
    private static final String IMAGE_KEY = "image";
    private static final String FILES_KEY = "files";

    CIP68NFT() {
        super(222);
    }

    private CIP68NFT(CIP68Datum datum) {
        super(222, datum);
    }

    public static CIP68NFT create() {
        return new CIP68NFT();
    }

    public CIP68NFT image(String imageUri) {
        this.property(IMAGE_KEY, imageUri);
        return this;
    }

    public String getImage() {
        return this.getStringProperty(IMAGE_KEY);
    }

    public CIP68NFT addFile(@NonNull CIP68File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        ListPlutusData files = (ListPlutusData)this.getProperty((PlutusData)CIP68Util.toByteString(FILES_KEY));
        if (files == null) {
            files = new ListPlutusData();
            this.property((PlutusData)CIP68Util.toByteString(FILES_KEY), (PlutusData)files);
        }
        files.add((PlutusData)file.toPlutusData());
        return this;
    }

    public List<CIP68File> getFiles() {
        ListPlutusData filesList = (ListPlutusData)this.getProperty((PlutusData)CIP68Util.toByteString(FILES_KEY));
        ArrayList<CIP68File> files = new ArrayList<CIP68File>();
        for (PlutusData filePD : filesList.getPlutusDataList()) {
            CIP68File file = CIP68File.create((MapPlutusData)filePD);
            files.add(file);
        }
        return files;
    }

    public static CIP68NFT fromDatum(byte[] datumBytes) {
        CIP68NFT token = CIP68NFT.create();
        token.populateFromDatumBytes(datumBytes);
        return token;
    }
}

