/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip68.common;

import com.bloxbean.cardano.client.plutus.spec.BigIntPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ConstrPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ListPlutusData;
import com.bloxbean.cardano.client.plutus.spec.MapPlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.util.PlutusDataPrettyPrinter;
import java.math.BigInteger;

public class CIP68Datum {
    private int version = 1;
    private PlutusData extra = PlutusData.unit();
    private MapPlutusData metadata;

    private CIP68Datum(MapPlutusData metadata) {
        this.metadata = metadata;
    }

    public static CIP68Datum create(MapPlutusData metadata) {
        return new CIP68Datum(metadata);
    }

    public CIP68Datum version(int version) {
        this.version = version;
        return this;
    }

    public CIP68Datum extra(PlutusData extra) {
        this.extra = extra;
        return this;
    }

    public MapPlutusData getMetadata() {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata;
    }

    public String getMetadataJson() {
        if (this.metadata == null) {
            return null;
        }
        return PlutusDataPrettyPrinter.toJson((PlutusData)this.metadata);
    }

    public ConstrPlutusData asPlutusData() {
        return ConstrPlutusData.builder().data(ListPlutusData.of((PlutusData[])new PlutusData[]{this.metadata, BigIntPlutusData.of((BigInteger)BigInteger.valueOf(this.version)), this.extra})).build();
    }

    public int getVersion() {
        return this.version;
    }

    public PlutusData getExtra() {
        return this.extra;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setExtra(PlutusData extra) {
        this.extra = extra;
    }

    public void setMetadata(MapPlutusData metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CIP68Datum)) {
            return false;
        }
        CIP68Datum other = (CIP68Datum)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        PlutusData this$extra = this.getExtra();
        PlutusData other$extra = other.getExtra();
        if (this$extra == null ? other$extra != null : !this$extra.equals(other$extra)) {
            return false;
        }
        MapPlutusData this$metadata = this.getMetadata();
        MapPlutusData other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CIP68Datum;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVersion();
        PlutusData $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        MapPlutusData $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        return result;
    }

    public String toString() {
        return "CIP68Datum(version=" + this.getVersion() + ", extra=" + this.getExtra() + ", metadata=" + this.getMetadata() + ")";
    }
}

