/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip68.common;

import com.bloxbean.cardano.client.cip.cip68.common.CIP68Util;
import com.bloxbean.cardano.client.plutus.spec.BigIntPlutusData;
import com.bloxbean.cardano.client.plutus.spec.BytesPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ListPlutusData;
import com.bloxbean.cardano.client.plutus.spec.MapPlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.util.PlutusDataPrettyPrinter;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;

public class DatumProperties<T> {
    protected MapPlutusData mapPlutusData;

    public DatumProperties() {
        this.mapPlutusData = new MapPlutusData();
    }

    public DatumProperties(MapPlutusData mapPlutusData) {
        this.mapPlutusData = mapPlutusData;
    }

    public T property(String name, String value) {
        this.mapPlutusData.put((PlutusData)CIP68Util.toByteString(name), (PlutusData)CIP68Util.toByteString(value));
        return (T)this;
    }

    public String getStringProperty(String name) {
        BytesPlutusData datumValue = (BytesPlutusData)this.mapPlutusData.getMap().get(CIP68Util.toByteString(name));
        if (datumValue == null) {
            return null;
        }
        return CIP68Util.fromByteString(datumValue);
    }

    public T property(String name, int value) {
        this.mapPlutusData.put((PlutusData)CIP68Util.toByteString(name), (PlutusData)BigIntPlutusData.of((int)value));
        return (T)this;
    }

    public Integer getIntProperty(String name) {
        BigIntPlutusData datumValue = (BigIntPlutusData)this.mapPlutusData.getMap().get(CIP68Util.toByteString(name));
        if (datumValue == null) {
            return null;
        }
        return datumValue.getValue().intValue();
    }

    public T property(String name, long value) {
        this.mapPlutusData.put((PlutusData)CIP68Util.toByteString(name), (PlutusData)BigIntPlutusData.of((long)value));
        return (T)this;
    }

    public Long getLongProperty(String name) {
        BigIntPlutusData datumValue = (BigIntPlutusData)this.mapPlutusData.getMap().get(CIP68Util.toByteString(name));
        if (datumValue == null) {
            return null;
        }
        return datumValue.getValue().longValue();
    }

    public T property(String name, BigInteger value) {
        this.mapPlutusData.put((PlutusData)CIP68Util.toByteString(name), (PlutusData)BigIntPlutusData.of((BigInteger)value));
        return (T)this;
    }

    public BigInteger getBigIntegerProperty(String name) {
        BigIntPlutusData datumValue = (BigIntPlutusData)this.mapPlutusData.getMap().get(CIP68Util.toByteString(name));
        if (datumValue == null) {
            return null;
        }
        return datumValue.getValue();
    }

    public T property(String name, List<String> values) {
        if (values == null || values.isEmpty()) {
            return (T)this;
        }
        List<BytesPlutusData> valuesPlutusDataList = values.stream().map(CIP68Util::toByteString).collect(Collectors.toList());
        this.mapPlutusData.put((PlutusData)CIP68Util.toByteString(name), (PlutusData)ListPlutusData.of((PlutusData[])((PlutusData[])valuesPlutusDataList.toArray(new BytesPlutusData[0]))));
        return (T)this;
    }

    public List<String> getListProperty(String name) {
        ListPlutusData listPlutusData = (ListPlutusData)this.mapPlutusData.getMap().get(CIP68Util.toByteString(name));
        if (listPlutusData == null) {
            return null;
        }
        List values = listPlutusData.getPlutusDataList().stream().map(plutusData -> (BytesPlutusData)plutusData).collect(Collectors.toList());
        return values.stream().map(CIP68Util::fromByteString).collect(Collectors.toList());
    }

    public T property(PlutusData key, PlutusData value) {
        this.mapPlutusData.put(key, value);
        return (T)this;
    }

    public PlutusData getProperty(PlutusData key) {
        return (PlutusData)this.mapPlutusData.getMap().get(key);
    }

    public MapPlutusData toPlutusData() {
        return this.mapPlutusData;
    }

    public String toJson() {
        try {
            return PlutusDataPrettyPrinter.toJson((PlutusData)this.mapPlutusData);
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

