/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip68;

import com.bloxbean.cardano.client.cip.cip68.common.CIP68Datum;
import com.bloxbean.cardano.client.cip.cip68.common.CIP68File;
import com.bloxbean.cardano.client.cip.cip68.common.CIP68TokenTemplate;
import com.bloxbean.cardano.client.cip.cip68.common.CIP68Util;
import com.bloxbean.cardano.client.plutus.spec.BigIntPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ListPlutusData;
import com.bloxbean.cardano.client.plutus.spec.MapPlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class CIP68RFT
extends CIP68TokenTemplate<CIP68RFT> {
    private static final int ASSET_NAME_LABEL = 444;
    private static final String IMAGE_KEY = "image";
    private static final String DECIMALS_KEY = "decimals";
    private static final String FILES_KEY = "files";

    CIP68RFT() {
        super(444);
        this.getDatum().setVersion(2);
    }

    private CIP68RFT(CIP68Datum cip68Datum) {
        super(444, cip68Datum);
        this.getDatum().setVersion(2);
    }

    public static CIP68RFT create() {
        return new CIP68RFT();
    }

    public CIP68RFT image(String image) {
        this.property(IMAGE_KEY, image);
        return this;
    }

    public String getImage() {
        return this.getStringProperty(IMAGE_KEY);
    }

    public CIP68RFT decimals(int decimals) {
        this.property((PlutusData)CIP68Util.toByteString(DECIMALS_KEY), (PlutusData)BigIntPlutusData.of((int)decimals));
        return this;
    }

    public Integer getDecimals() {
        BigIntPlutusData decimalsPlutusData = (BigIntPlutusData)this.mapPlutusData.getMap().get(CIP68Util.toByteString(DECIMALS_KEY));
        if (decimalsPlutusData == null) {
            return null;
        }
        return decimalsPlutusData.getValue().intValue();
    }

    public CIP68RFT addFile(@NonNull CIP68File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        ListPlutusData files = (ListPlutusData)this.getProperty((PlutusData)CIP68Util.toByteString(FILES_KEY));
        if (files == null) {
            files = new ListPlutusData();
            this.property((PlutusData)CIP68Util.toByteString(FILES_KEY), (PlutusData)files);
        }
        files.add((PlutusData)file.toPlutusData());
        return this;
    }

    public List<CIP68File> getFiles() {
        ListPlutusData filesList = (ListPlutusData)this.getProperty((PlutusData)CIP68Util.toByteString(FILES_KEY));
        ArrayList<CIP68File> files = new ArrayList<CIP68File>();
        for (PlutusData filePD : filesList.getPlutusDataList()) {
            CIP68File file = CIP68File.create((MapPlutusData)filePD);
            files.add(file);
        }
        return files;
    }

    public static CIP68RFT fromDatum(byte[] datumBytes) {
        CIP68RFT token = CIP68RFT.create();
        token.populateFromDatumBytes(datumBytes);
        return token;
    }
}

