/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip68.common;

import com.bloxbean.cardano.client.plutus.spec.BytesPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ListPlutusData;
import com.bloxbean.cardano.client.plutus.spec.MapPlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.StringUtils;
import java.nio.charset.StandardCharsets;

public class CIP68Util {
    public static void addSingleOrMultipleValues(MapPlutusData mapPlutusData, String key, String value) {
        Object descValue = mapPlutusData.getMap().get(CIP68Util.toByteString(key));
        if (descValue == null) {
            mapPlutusData.getMap().put(CIP68Util.toByteString(key), CIP68Util.toByteString(value));
            return;
        }
        ListPlutusData list = null;
        if (descValue instanceof BytesPlutusData) {
            list = new ListPlutusData();
            list.add((PlutusData)descValue);
            mapPlutusData.put((PlutusData)CIP68Util.toByteString(key), (PlutusData)list);
        } else if (descValue instanceof ListPlutusData) {
            list = (ListPlutusData)descValue;
        } else {
            mapPlutusData.put((PlutusData)CIP68Util.toByteString(key), (PlutusData)CIP68Util.toByteString(value));
            return;
        }
        list.add((PlutusData)CIP68Util.toByteString(value));
    }

    public static BytesPlutusData toByteString(String value) {
        return BytesPlutusData.of((String)value);
    }

    public static String fromByteString(BytesPlutusData bytesPlutusData) {
        if (bytesPlutusData == null) {
            return null;
        }
        byte[] bytes = bytesPlutusData.getValue();
        if (StringUtils.isUtf8String((byte[])bytes)) {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        return HexUtil.encodeHexString((byte[])bytes, (boolean)true);
    }
}

