/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip68.common;

import com.bloxbean.cardano.client.cip.cip68.common.CIP68Util;
import com.bloxbean.cardano.client.cip.cip68.common.DatumProperties;
import com.bloxbean.cardano.client.plutus.spec.BytesPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ListPlutusData;
import com.bloxbean.cardano.client.plutus.spec.MapPlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CIP68File
extends DatumProperties<CIP68File> {
    public static final String NAME_KEY = "name";
    public static final String MEDIA_TYPE_KEY = "mediaType";
    public static final String SRC_KEY = "src";

    private CIP68File() {
    }

    private CIP68File(MapPlutusData map) {
        super(map);
    }

    public static CIP68File create() {
        return new CIP68File();
    }

    public static CIP68File create(MapPlutusData map) {
        return new CIP68File(map);
    }

    public CIP68File name(String name) {
        this.property(NAME_KEY, name);
        return this;
    }

    public String getName() {
        return this.getStringProperty(NAME_KEY);
    }

    public CIP68File mediaType(String mediaType) {
        this.property(MEDIA_TYPE_KEY, mediaType);
        return this;
    }

    public String getMediaType() {
        return this.getStringProperty(MEDIA_TYPE_KEY);
    }

    public CIP68File src(String uri) {
        CIP68Util.addSingleOrMultipleValues(this.mapPlutusData, SRC_KEY, uri);
        return this;
    }

    public CIP68File setsrcs(List<String> uris) {
        if (uris == null || uris.size() == 0) {
            return this;
        }
        ListPlutusData list = new ListPlutusData();
        for (String uri : uris) {
            list.add((PlutusData)CIP68Util.toByteString(uri));
        }
        this.property((PlutusData)CIP68Util.toByteString(SRC_KEY), (PlutusData)list);
        return this;
    }

    public List<String> getSrcs() {
        PlutusData value = this.getProperty((PlutusData)CIP68Util.toByteString(SRC_KEY));
        if (value instanceof BytesPlutusData) {
            return Arrays.asList(CIP68Util.fromByteString((BytesPlutusData)value));
        }
        if (value instanceof ListPlutusData) {
            ListPlutusData list = (ListPlutusData)value;
            return list.getPlutusDataList().stream().map(plutusData -> (BytesPlutusData)plutusData).map(CIP68Util::fromByteString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

