/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip68.common;

import com.bloxbean.cardano.client.cip.cip67.CIP67AssetNameUtil;
import com.bloxbean.cardano.client.cip.cip68.CIP68ReferenceToken;
import com.bloxbean.cardano.client.cip.cip68.common.CIP68Datum;
import com.bloxbean.cardano.client.cip.cip68.common.CIP68Util;
import com.bloxbean.cardano.client.cip.cip68.common.DatumProperties;
import com.bloxbean.cardano.client.crypto.bip32.util.BytesUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.plutus.spec.BigIntPlutusData;
import com.bloxbean.cardano.client.plutus.spec.BytesPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ConstrPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ListPlutusData;
import com.bloxbean.cardano.client.plutus.spec.MapPlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.util.PlutusDataPrettyPrinter;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.util.HexUtil;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;

public abstract class CIP68TokenTemplate<T extends CIP68TokenTemplate>
extends DatumProperties<T> {
    public static final String DESCRIPTION_KEY = "description";
    public static final String NAME_KEY = "name";
    private int assetNameLabel;
    private byte[] nameBytes;
    private CIP68Datum cip68Datum;

    public CIP68TokenTemplate(int assetNameLabel) {
        this.assetNameLabel = assetNameLabel;
        this.cip68Datum = CIP68Datum.create(this.mapPlutusData);
    }

    public CIP68TokenTemplate(int assetNameLabel, CIP68Datum cip68Datum) {
        super(cip68Datum.getMetadata());
        this.assetNameLabel = assetNameLabel;
        this.cip68Datum = cip68Datum;
    }

    public CIP68TokenTemplate(String assetName, int assetNameLabel, CIP68Datum cip68Datum) {
        super(cip68Datum.getMetadata());
        this.assetNameLabel = assetNameLabel;
        this.nameBytes = assetName.getBytes(StandardCharsets.UTF_8);
        this.cip68Datum = cip68Datum;
    }

    public int getAssetNameLabel() {
        return this.assetNameLabel;
    }

    public String getAssetNameAsHex() {
        byte[] assetNameLabelBytes = CIP67AssetNameUtil.labelToPrefix((int)this.assetNameLabel);
        return "0x" + new String(HexUtil.encodeHexString((byte[])assetNameLabelBytes)) + HexUtil.encodeHexString((byte[])this.nameBytes);
    }

    public byte[] getAssetNameAsBytes() {
        byte[] assetNameLabelBytes = CIP67AssetNameUtil.labelToPrefix((int)this.assetNameLabel);
        return BytesUtil.merge((byte[])assetNameLabelBytes, (byte[])this.nameBytes);
    }

    public CIP68ReferenceToken getReferenceToken() {
        return new CIP68ReferenceToken(this);
    }

    public Asset getAsset(BigInteger value) {
        String assetNameHex = this.getAssetNameAsHex();
        if (HexUtil.decodeHexString((String)assetNameHex).length > 32) {
            throw new IllegalArgumentException("Asset name length cannot be more than 32 bytes");
        }
        return new Asset(this.getAssetNameAsHex(), value);
    }

    public CIP68Datum getDatum() {
        return this.cip68Datum;
    }

    public String getFriendlyAssetName() {
        return String.format("(%d) %s", this.assetNameLabel, this.getName());
    }

    public T name(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.nameBytes = name.getBytes(StandardCharsets.UTF_8);
        this.property((PlutusData)CIP68Util.toByteString(NAME_KEY), (PlutusData)CIP68Util.toByteString(name));
        return (T)this;
    }

    public T name(byte[] nameBytes) {
        this.nameBytes = nameBytes;
        this.property((PlutusData)CIP68Util.toByteString(NAME_KEY), (PlutusData)BytesPlutusData.of((byte[])this.nameBytes));
        return (T)this;
    }

    public T description(String description) {
        this.property((PlutusData)CIP68Util.toByteString(DESCRIPTION_KEY), (PlutusData)CIP68Util.toByteString(description));
        return (T)this;
    }

    public String getName() {
        BytesPlutusData valuePlutusData = (BytesPlutusData)this.mapPlutusData.getMap().get(CIP68Util.toByteString(NAME_KEY));
        return CIP68Util.fromByteString(valuePlutusData);
    }

    public String getDescription() {
        BytesPlutusData valuePlutusData = (BytesPlutusData)this.mapPlutusData.getMap().get(CIP68Util.toByteString(DESCRIPTION_KEY));
        return CIP68Util.fromByteString(valuePlutusData);
    }

    protected T populateFromDatumBytes(byte[] datumBytes) {
        try {
            ConstrPlutusData constrPlutusData = (ConstrPlutusData)PlutusData.deserialize((byte[])datumBytes);
            ListPlutusData list = constrPlutusData.getData();
            MapPlutusData metadataMapPlutusData = (MapPlutusData)list.getPlutusDataList().get(0);
            int version = ((BigIntPlutusData)list.getPlutusDataList().get(1)).getValue().intValue();
            PlutusData extra = (PlutusData)list.getPlutusDataList().get(2);
            CIP68Datum datum = CIP68Datum.create(metadataMapPlutusData);
            datum.setVersion(version);
            datum.setExtra(extra);
            this.cip68Datum = datum;
            this.nameBytes = ((BytesPlutusData)metadataMapPlutusData.getMap().get(CIP68Util.toByteString(NAME_KEY))).getValue();
            this.name(this.nameBytes);
            this.mapPlutusData = metadataMapPlutusData;
            return (T)this;
        }
        catch (CborDeserializationException e) {
            throw new CborRuntimeException("Error deserializing CIP68 Metadata", (Exception)((Object)e));
        }
    }

    public MapPlutusData getMetadata() {
        return this.mapPlutusData;
    }

    public String getMetadataJson() {
        return PlutusDataPrettyPrinter.toJson((PlutusData)this.getMetadata());
    }

    public ConstrPlutusData getDatumAsPlutusData() {
        return this.getDatum().asPlutusData();
    }
}

