/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip8;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Tag;
import com.bloxbean.cardano.client.cip.cip8.COSEEncrypt;
import com.bloxbean.cardano.client.cip.cip8.COSEItem;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import lombok.NonNull;

public class PubKeyEncryption
implements COSEItem {
    private final COSEEncrypt coseEncrypt;

    public PubKeyEncryption(COSEEncrypt coseEncrypt) {
        this.coseEncrypt = coseEncrypt;
    }

    public static PubKeyEncryption deserialize(@NonNull DataItem dataItem) {
        if (dataItem == null) {
            throw new NullPointerException("dataItem is marked non-null but is null");
        }
        Tag tag = dataItem.getTag();
        if (tag == null || tag.getValue() != 96L) {
            throw new CborRuntimeException("Cbor de-serialization error. Invalid or null tag. Expected value: 96");
        }
        return new PubKeyEncryption(COSEEncrypt.deserialize((Array)dataItem));
    }

    @Override
    public DataItem serialize() {
        if (this.coseEncrypt == null) {
            throw new CborRuntimeException("Cbor serialization error. COSEEncrypt can't be null");
        }
        Array coseEncryptArr = this.coseEncrypt.serialize();
        coseEncryptArr.setTag(96L);
        return coseEncryptArr;
    }

    public COSEEncrypt coseEncrypt() {
        return this.coseEncrypt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PubKeyEncryption)) {
            return false;
        }
        PubKeyEncryption other = (PubKeyEncryption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        COSEEncrypt this$coseEncrypt = this.coseEncrypt();
        COSEEncrypt other$coseEncrypt = other.coseEncrypt();
        return !(this$coseEncrypt == null ? other$coseEncrypt != null : !((Object)this$coseEncrypt).equals(other$coseEncrypt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PubKeyEncryption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        COSEEncrypt $coseEncrypt = this.coseEncrypt();
        result = result * 59 + ($coseEncrypt == null ? 43 : ((Object)$coseEncrypt).hashCode());
        return result;
    }

    public String toString() {
        return "PubKeyEncryption(coseEncrypt=" + this.coseEncrypt() + ")";
    }
}

