/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip8;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import com.bloxbean.cardano.client.cip.cip8.COSEItem;
import com.bloxbean.cardano.client.cip.cip8.COSERecipient;
import com.bloxbean.cardano.client.cip.cip8.Headers;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class COSEEncrypt
implements COSEItem {
    private Headers headers;
    private byte[] ciphertext;
    private List<COSERecipient> recipients = new ArrayList<COSERecipient>();

    public static COSEEncrypt deserialize(Array consencArray) {
        List dataItems = consencArray.getDataItems();
        if (dataItems.size() != 4) {
            throw new CborRuntimeException(String.format("De-serialization error. Expected array size: 4, Found: %s", dataItems.size()));
        }
        Headers headers = Headers.deserialize(new DataItem[]{(DataItem)dataItems.get(0), (DataItem)dataItems.get(1)});
        byte[] ciphertext = ((ByteString)dataItems.get(2)).getBytes();
        Array recipientArray = (Array)dataItems.get(3);
        List<COSERecipient> recipients = recipientArray.getDataItems().stream().map(dataItem -> COSERecipient.deserialize((Array)dataItem)).collect(Collectors.toList());
        return new COSEEncrypt(headers, ciphertext, recipients);
    }

    public COSEEncrypt recipient(COSERecipient recipient) {
        this.recipients.add(recipient);
        return this;
    }

    public Array serialize() {
        Array cosencArray = new Array();
        Arrays.stream(this.headers.serialize()).forEach(header -> cosencArray.add(header));
        if (this.ciphertext != null) {
            cosencArray.add((DataItem)new ByteString(this.ciphertext));
        } else {
            cosencArray.add((DataItem)SimpleValue.NULL);
        }
        if (this.recipients == null || this.recipients.size() <= 0) {
            throw new CborRuntimeException("Serialization error. At least 1 recipient is required.");
        }
        Array rcptArray = new Array();
        this.recipients.stream().forEach(coseRecipient -> rcptArray.add((DataItem)coseRecipient.serialize()));
        cosencArray.add((DataItem)rcptArray);
        return cosencArray;
    }

    public Headers headers() {
        return this.headers;
    }

    public byte[] ciphertext() {
        return this.ciphertext;
    }

    public List<COSERecipient> recipients() {
        return this.recipients;
    }

    public COSEEncrypt headers(Headers headers) {
        this.headers = headers;
        return this;
    }

    public COSEEncrypt ciphertext(byte[] ciphertext) {
        this.ciphertext = ciphertext;
        return this;
    }

    public COSEEncrypt recipients(List<COSERecipient> recipients) {
        this.recipients = recipients;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof COSEEncrypt)) {
            return false;
        }
        COSEEncrypt other = (COSEEncrypt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Headers this$headers = this.headers();
        Headers other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        if (!Arrays.equals(this.ciphertext(), other.ciphertext())) {
            return false;
        }
        List<COSERecipient> this$recipients = this.recipients();
        List<COSERecipient> other$recipients = other.recipients();
        return !(this$recipients == null ? other$recipients != null : !((Object)this$recipients).equals(other$recipients));
    }

    protected boolean canEqual(Object other) {
        return other instanceof COSEEncrypt;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Headers $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + Arrays.hashCode(this.ciphertext());
        List<COSERecipient> $recipients = this.recipients();
        result = result * 59 + ($recipients == null ? 43 : ((Object)$recipients).hashCode());
        return result;
    }

    public String toString() {
        return "COSEEncrypt(headers=" + String.valueOf(this.headers()) + ", ciphertext=" + Arrays.toString(this.ciphertext()) + ", recipients=" + String.valueOf(this.recipients()) + ")";
    }

    public COSEEncrypt(Headers headers, byte[] ciphertext, List<COSERecipient> recipients) {
        this.headers = headers;
        this.ciphertext = ciphertext;
        this.recipients = recipients;
    }

    public COSEEncrypt() {
    }
}

