/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip8;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.SimpleValue;
import com.bloxbean.cardano.client.cip.cip8.COSEItem;
import com.bloxbean.cardano.client.cip.cip8.Headers;
import com.bloxbean.cardano.client.cip.cip8.SigContext;
import com.bloxbean.cardano.client.cip.cip8.SigStructure;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import java.util.Arrays;
import java.util.List;

public class COSESign1
implements COSEItem {
    private Headers headers;
    private byte[] payload;
    private byte[] signature;

    public static COSESign1 deserialize(byte[] bytes) {
        try {
            DataItem dataItem = (DataItem)CborDecoder.decode((byte[])bytes).get(0);
            return COSESign1.deserialize(dataItem);
        }
        catch (CborException e) {
            throw new CborRuntimeException("De-serialization error.", (Exception)((Object)e));
        }
    }

    public static COSESign1 deserialize(DataItem dataItem) {
        Headers headers;
        if (!MajorType.ARRAY.equals((Object)dataItem.getMajorType())) {
            throw new CborRuntimeException(String.format("De-serialization error. Expected type: Array, Found: %s", dataItem.getMajorType()));
        }
        Array coseSignArray = (Array)dataItem;
        List coseSignDIs = coseSignArray.getDataItems();
        if (coseSignDIs.size() != 4) {
            throw new CborRuntimeException(String.format("De-serialization error. Invalid array size. Expected size: , Found: %s", coseSignDIs.size()));
        }
        COSESign1 coseSign1 = new COSESign1();
        coseSign1.headers = headers = Headers.deserialize(new DataItem[]{(DataItem)coseSignDIs.get(0), (DataItem)coseSignDIs.get(1)});
        coseSign1.payload = (byte[])(coseSignDIs.get(2) == SimpleValue.NULL ? null : ((ByteString)coseSignDIs.get(2)).getBytes());
        ByteString signatureBS = (ByteString)coseSignDIs.get(3);
        coseSign1.signature = signatureBS.getBytes();
        return coseSign1;
    }

    public Array serialize() {
        Array array = new Array();
        Arrays.stream(this.headers.serialize()).forEach(headerItem -> array.add(headerItem));
        if (this.payload != null && this.payload.length > 0) {
            array.add((DataItem)new ByteString(this.payload));
        } else {
            array.add((DataItem)SimpleValue.NULL);
        }
        if (this.signature != null) {
            array.add((DataItem)new ByteString(this.signature));
        } else {
            array.add((DataItem)new ByteString(new byte[0]));
        }
        return array;
    }

    public SigStructure signedData() {
        return this.signedData(null, null);
    }

    public SigStructure signedData(byte[] externalAad, byte[] externalPayload) {
        byte[] _payload;
        if (externalPayload != null) {
            _payload = (byte[])externalPayload.clone();
        } else if (this.payload != null) {
            _payload = (byte[])this.payload.clone();
        } else {
            throw new IllegalArgumentException("Payload is not present and no external payload is supplied.");
        }
        return new SigStructure().sigContext(SigContext.Signature1).bodyProtected(this.headers._protected()).payload(_payload).externalAad(externalAad);
    }

    public Headers headers() {
        return this.headers;
    }

    public byte[] payload() {
        return this.payload;
    }

    public byte[] signature() {
        return this.signature;
    }

    public COSESign1 headers(Headers headers) {
        this.headers = headers;
        return this;
    }

    public COSESign1 payload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public COSESign1 signature(byte[] signature) {
        this.signature = signature;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof COSESign1)) {
            return false;
        }
        COSESign1 other = (COSESign1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Headers this$headers = this.headers();
        Headers other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        if (!Arrays.equals(this.payload(), other.payload())) {
            return false;
        }
        return Arrays.equals(this.signature(), other.signature());
    }

    protected boolean canEqual(Object other) {
        return other instanceof COSESign1;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Headers $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + Arrays.hashCode(this.payload());
        result = result * 59 + Arrays.hashCode(this.signature());
        return result;
    }

    public String toString() {
        return "COSESign1(headers=" + String.valueOf(this.headers()) + ", payload=" + Arrays.toString(this.payload()) + ", signature=" + Arrays.toString(this.signature()) + ")";
    }

    public COSESign1() {
    }

    public COSESign1(Headers headers, byte[] payload, byte[] signature) {
        this.headers = headers;
        this.payload = payload;
        this.signature = signature;
    }
}

