/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip8;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import com.bloxbean.cardano.client.cip.cip8.COSEItem;
import com.bloxbean.cardano.client.cip.cip8.Headers;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public class COSESignature
implements COSEItem {
    private Headers headers;
    private byte[] signature;

    public static COSESignature deserialize(@NonNull DataItem dataItem) {
        if (dataItem == null) {
            throw new NullPointerException("dataItem is marked non-null but is null");
        }
        if (!MajorType.ARRAY.equals((Object)dataItem.getMajorType())) {
            throw new CborRuntimeException(String.format("De-serialization error. Expected type: Array, Found: %s", dataItem.getMajorType()));
        }
        Array coseSigArray = (Array)dataItem;
        List coseSigDIs = coseSigArray.getDataItems();
        if (coseSigDIs.size() != 3) {
            throw new CborRuntimeException(String.format("De-serialization error: Invalid array size. Expected: 3, Found: %d", coseSigDIs.size()));
        }
        COSESignature coseSignature = new COSESignature();
        coseSignature.headers = Headers.deserialize(new DataItem[]{(DataItem)coseSigDIs.get(0), (DataItem)coseSigDIs.get(1)});
        coseSignature.signature = ((ByteString)coseSigDIs.get(2)).getBytes();
        return coseSignature;
    }

    public Array serialize() {
        Array array = new Array();
        Arrays.stream(this.headers.serialize()).forEach(headerItem -> array.add(headerItem));
        array.add((DataItem)new ByteString(this.signature));
        return array;
    }

    public Headers headers() {
        return this.headers;
    }

    public byte[] signature() {
        return this.signature;
    }

    public COSESignature headers(Headers headers) {
        this.headers = headers;
        return this;
    }

    public COSESignature signature(byte[] signature) {
        this.signature = signature;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof COSESignature)) {
            return false;
        }
        COSESignature other = (COSESignature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Headers this$headers = this.headers();
        Headers other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        return Arrays.equals(this.signature(), other.signature());
    }

    protected boolean canEqual(Object other) {
        return other instanceof COSESignature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Headers $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + Arrays.hashCode(this.signature());
        return result;
    }

    public String toString() {
        return "COSESignature(headers=" + String.valueOf(this.headers()) + ", signature=" + Arrays.toString(this.signature()) + ")";
    }

    public COSESignature() {
    }

    public COSESignature(Headers headers, byte[] signature) {
        this.headers = headers;
        this.signature = signature;
    }
}

