/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip8.builder;

import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import com.bloxbean.cardano.client.cip.cip8.COSESign;
import com.bloxbean.cardano.client.cip.cip8.COSESignature;
import com.bloxbean.cardano.client.cip.cip8.Headers;
import com.bloxbean.cardano.client.cip.cip8.SigContext;
import com.bloxbean.cardano.client.cip.cip8.SigStructure;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import java.util.Arrays;
import java.util.List;

public class COSESignBuilder {
    private Headers headers;
    private byte[] payload;
    private byte[] externalAad;
    private boolean isPayloadExternal;
    private boolean hashed;

    public COSESignBuilder(Headers headers, byte[] payload, boolean isPayloadExternal) {
        this.headers = headers;
        this.payload = payload;
        this.isPayloadExternal = isPayloadExternal;
    }

    public SigStructure makeDataToSign() {
        Headers headersCopy = this.headers.copy();
        byte[] finalPayload = this.isPayloadExternal ? (byte[])this.payload.clone() : (this.hashed ? Blake2bUtil.blake2bHash224((byte[])this.payload) : (byte[])this.payload.clone());
        return new SigStructure().sigContext(SigContext.Signature).bodyProtected(headersCopy._protected()).externalAad(this.externalAad != null ? (byte[])this.externalAad.clone() : new byte[]{}).payload(finalPayload);
    }

    public COSESign build(List<COSESignature> coseSignatures) {
        Headers allHeader = this.headers.copy();
        allHeader.unprotected().addOtherHeader("hashed", (DataItem)(this.hashed ? SimpleValue.TRUE : SimpleValue.FALSE));
        byte[] finalPayload = this.hashed ? Blake2bUtil.blake2bHash224((byte[])this.payload) : (byte[])this.payload.clone();
        return new COSESign().headers(allHeader).payload(this.isPayloadExternal ? null : finalPayload).signatures(coseSignatures);
    }

    public Headers headers() {
        return this.headers;
    }

    public byte[] payload() {
        return this.payload;
    }

    public byte[] externalAad() {
        return this.externalAad;
    }

    public boolean isPayloadExternal() {
        return this.isPayloadExternal;
    }

    public boolean hashed() {
        return this.hashed;
    }

    public COSESignBuilder headers(Headers headers) {
        this.headers = headers;
        return this;
    }

    public COSESignBuilder payload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public COSESignBuilder externalAad(byte[] externalAad) {
        this.externalAad = externalAad;
        return this;
    }

    public COSESignBuilder isPayloadExternal(boolean isPayloadExternal) {
        this.isPayloadExternal = isPayloadExternal;
        return this;
    }

    public COSESignBuilder hashed(boolean hashed) {
        this.hashed = hashed;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof COSESignBuilder)) {
            return false;
        }
        COSESignBuilder other = (COSESignBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPayloadExternal() != other.isPayloadExternal()) {
            return false;
        }
        if (this.hashed() != other.hashed()) {
            return false;
        }
        Headers this$headers = this.headers();
        Headers other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        if (!Arrays.equals(this.payload(), other.payload())) {
            return false;
        }
        return Arrays.equals(this.externalAad(), other.externalAad());
    }

    protected boolean canEqual(Object other) {
        return other instanceof COSESignBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPayloadExternal() ? 79 : 97);
        result = result * 59 + (this.hashed() ? 79 : 97);
        Headers $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + Arrays.hashCode(this.payload());
        result = result * 59 + Arrays.hashCode(this.externalAad());
        return result;
    }

    public String toString() {
        return "COSESignBuilder(headers=" + String.valueOf(this.headers()) + ", payload=" + Arrays.toString(this.payload()) + ", externalAad=" + Arrays.toString(this.externalAad()) + ", isPayloadExternal=" + this.isPayloadExternal() + ", hashed=" + this.hashed() + ")";
    }
}

