/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.coinselection.impl;

import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.api.exception.InsufficientBalanceException;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.coinselection.UtxoSelectionStrategy;
import com.bloxbean.cardano.client.coinselection.exception.InputsLimitExceededException;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LargestFirstUtxoSelectionStrategy
implements UtxoSelectionStrategy {
    private final UtxoSupplier utxoSupplier;
    private boolean ignoreUtxosWithDatumHash;

    public LargestFirstUtxoSelectionStrategy(UtxoSupplier utxoSupplier) {
        this(utxoSupplier, true);
    }

    public LargestFirstUtxoSelectionStrategy(UtxoSupplier utxoSupplier, boolean ignoreUtxosWithDatumHash) {
        this.utxoSupplier = utxoSupplier;
        this.ignoreUtxosWithDatumHash = ignoreUtxosWithDatumHash;
    }

    @Override
    public Set<Utxo> select(String sender, List<Amount> outputAmounts, String datumHash, PlutusData inlineDatum, Set<Utxo> utxosToExclude, int maxUtxoSelectionLimit) {
        if (outputAmounts == null || outputAmounts.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            HashSet<Utxo> selectedUtxos = new HashSet<Utxo>();
            Map<String, BigInteger> remaining = new HashMap<String, BigInteger>(outputAmounts.stream().collect(Collectors.groupingBy(Amount::getUnit, Collectors.reducing(BigInteger.ZERO, Amount::getQuantity, BigInteger::add)))).entrySet().stream().filter(entry -> BigInteger.ZERO.compareTo((BigInteger)entry.getValue()) < 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List fetchResult = this.utxoSupplier.getAll(sender);
            List allUtxos = fetchResult.stream().sorted(LargestFirstUtxoSelectionStrategy.sortLargestFirst(outputAmounts)).collect(Collectors.toList());
            for (Utxo utxo : allUtxos) {
                if (!this.accept(utxo) || utxosToExclude != null && utxosToExclude.contains(utxo) || utxo.getDataHash() != null && !utxo.getDataHash().isEmpty() && this.ignoreUtxosWithDatumHash || datumHash != null && !datumHash.isEmpty() && !datumHash.equals(utxo.getDataHash()) || inlineDatum != null && !inlineDatum.serializeToHex().equals(utxo.getInlineDatum()) || selectedUtxos.contains(utxo)) continue;
                List utxoAmounts = utxo.getAmount();
                boolean utxoSelected = false;
                for (Amount amount : utxoAmounts) {
                    BigInteger remainingAmount = remaining.get(amount.getUnit());
                    if (remainingAmount == null || BigInteger.ZERO.compareTo(remainingAmount) >= 0) continue;
                    utxoSelected = true;
                    BigInteger newRemaining = remainingAmount.subtract(amount.getQuantity());
                    if (BigInteger.ZERO.compareTo(newRemaining) < 0) {
                        remaining.put(amount.getUnit(), newRemaining);
                        continue;
                    }
                    remaining.remove(amount.getUnit());
                }
                if (!utxoSelected) continue;
                selectedUtxos.add(utxo);
                if (remaining.isEmpty() || selectedUtxos.size() <= maxUtxoSelectionLimit) continue;
                throw new InputsLimitExceededException("Selection limit of " + maxUtxoSelectionLimit + " utxos reached with " + remaining + " remaining");
            }
            if (!remaining.isEmpty()) {
                throw new InsufficientBalanceException("Not enough funds for [" + remaining + "]");
            }
            return selectedUtxos;
        }
        catch (InputsLimitExceededException e) {
            UtxoSelectionStrategy fallback = this.fallback();
            if (fallback != null) {
                return fallback.select(sender, outputAmounts, datumHash, inlineDatum, utxosToExclude, maxUtxoSelectionLimit);
            }
            throw new ApiRuntimeException("Input limit exceeded and no fallback provided", (Exception)e);
        }
    }

    private static Comparator<Utxo> sortLargestFirst(List<Amount> outputAmounts) {
        return (o1, o2) -> LargestFirstUtxoSelectionStrategy.countTotalAssetsQuantity(o2.getAmount(), outputAmounts).compareTo(LargestFirstUtxoSelectionStrategy.countTotalAssetsQuantity(o1.getAmount(), outputAmounts));
    }

    private static BigInteger countTotalAssetsQuantity(List<Amount> l1, List<Amount> outputAmounts) {
        Set outputAssets = outputAmounts.stream().map(Amount::getUnit).collect(Collectors.toSet());
        return l1.stream().filter(it -> outputAssets.contains(it.getUnit())).map(Amount::getQuantity).reduce(BigInteger.ZERO, BigInteger::add);
    }

    @Override
    public UtxoSelectionStrategy fallback() {
        return null;
    }

    protected boolean accept(Utxo utxo) {
        return true;
    }

    @Override
    public void setIgnoreUtxosWithDatumHash(boolean ignoreUtxosWithDatumHash) {
        this.ignoreUtxosWithDatumHash = ignoreUtxosWithDatumHash;
    }
}

