/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.coinselection.impl;

import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.coinselection.UtxoSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DefaultUtxoSelector
implements UtxoSelector {
    private UtxoSupplier utxoSupplier;

    public DefaultUtxoSelector(UtxoSupplier utxoSupplier) {
        this.utxoSupplier = utxoSupplier;
    }

    @Override
    public Optional<Utxo> findFirst(String address, Predicate<Utxo> predicate) throws ApiException {
        return this.findFirst(address, predicate, Collections.EMPTY_SET);
    }

    @Override
    public Optional<Utxo> findFirst(String address, Predicate<Utxo> predicate, Set<Utxo> excludeUtxos) throws ApiException {
        boolean canContinue = true;
        int i = 0;
        while (canContinue) {
            List data = this.utxoSupplier.getPage(address, Integer.valueOf(this.getUtxoFetchSize()), Integer.valueOf(i++), this.getUtxoFetchOrder());
            if (data == null || data.isEmpty()) {
                canContinue = false;
                continue;
            }
            Optional<Utxo> optional = data.stream().filter(predicate).filter(utxo -> !excludeUtxos.contains(utxo)).findFirst();
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public List<Utxo> findAll(String address, Predicate<Utxo> predicate) throws ApiException {
        return this.findAll(address, predicate, Collections.EMPTY_SET);
    }

    @Override
    public List<Utxo> findAll(String address, Predicate<Utxo> predicate, Set<Utxo> excludeUtxos) throws ApiException {
        boolean canContinue = true;
        int i = 0;
        ArrayList<Utxo> utxoList = new ArrayList<Utxo>();
        while (canContinue) {
            List data = this.utxoSupplier.getPage(address, Integer.valueOf(this.getUtxoFetchSize()), Integer.valueOf(i++), this.getUtxoFetchOrder());
            if (data == null || data.isEmpty()) {
                canContinue = false;
                continue;
            }
            List filterUtxos = data.stream().filter(predicate).filter(utxo -> !excludeUtxos.contains(utxo)).collect(Collectors.toList());
            utxoList.addAll(filterUtxos);
        }
        return utxoList;
    }

    protected OrderEnum getUtxoFetchOrder() {
        return OrderEnum.asc;
    }

    protected int getUtxoFetchSize() {
        return 100;
    }
}

