/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.coinselection.impl;

import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.coinselection.UtxoSelectionStrategy;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ExcludeUtxoSelectionStrategy
implements UtxoSelectionStrategy {
    private UtxoSelectionStrategy utxoSelectionStrategy;
    private Set<Utxo> excludeList;

    public ExcludeUtxoSelectionStrategy(UtxoSelectionStrategy utxoSelectionStrategy, Set<TransactionInput> inputsToExclude) {
        this.utxoSelectionStrategy = utxoSelectionStrategy;
        this.excludeList = inputsToExclude != null && !inputsToExclude.isEmpty() ? inputsToExclude.stream().map(input -> Utxo.builder().txHash(input.getTransactionId()).outputIndex(input.getIndex()).build()).collect(Collectors.toSet()) : Collections.emptySet();
    }

    @Override
    public Set<Utxo> select(String address, List<Amount> outputAmounts, String datumHash, PlutusData inlineDatum, Set<Utxo> utxosToExclude, int maxUtxoSelectionLimit) {
        Set<Utxo> finalUtxoToExclude;
        if (utxosToExclude != null) {
            finalUtxoToExclude = new HashSet<Utxo>(utxosToExclude);
            finalUtxoToExclude.addAll(this.excludeList);
        } else {
            finalUtxoToExclude = this.excludeList;
        }
        return this.utxoSelectionStrategy.select(address, outputAmounts, datumHash, inlineDatum, finalUtxoToExclude, maxUtxoSelectionLimit);
    }

    @Override
    public UtxoSelectionStrategy fallback() {
        return this.utxoSelectionStrategy.fallback();
    }

    @Override
    public void setIgnoreUtxosWithDatumHash(boolean ignoreUtxosWithDatumHash) {
        this.utxoSelectionStrategy.setIgnoreUtxosWithDatumHash(ignoreUtxosWithDatumHash);
    }
}

