/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.coinselection.impl;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.coinselection.UtxoSelector;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ExcludeUtxoSelector
implements UtxoSelector {
    private UtxoSelector utxoSelector;
    private Set<Utxo> excludeList;

    public ExcludeUtxoSelector(UtxoSelector utxoSelector, Set<TransactionInput> inputsToExclude) {
        Objects.requireNonNull(utxoSelector, "UtxoSelector is required");
        this.utxoSelector = utxoSelector;
        this.excludeList = inputsToExclude != null && !inputsToExclude.isEmpty() ? inputsToExclude.stream().map(input -> Utxo.builder().txHash(input.getTransactionId()).outputIndex(input.getIndex()).build()).collect(Collectors.toSet()) : Collections.emptySet();
    }

    @Override
    public Optional<Utxo> findFirst(String address, Predicate<Utxo> predicate) throws ApiException {
        return this.utxoSelector.findFirst(address, predicate, this.getFinalExcludeList(Collections.emptySet()));
    }

    @Override
    public Optional<Utxo> findFirst(String address, Predicate<Utxo> predicate, Set<Utxo> excludeUtxos) throws ApiException {
        return this.utxoSelector.findFirst(address, predicate, this.getFinalExcludeList(excludeUtxos));
    }

    @Override
    public List<Utxo> findAll(String address, Predicate<Utxo> predicate) throws ApiException {
        return this.utxoSelector.findAll(address, predicate, this.getFinalExcludeList(Collections.emptySet()));
    }

    @Override
    public List<Utxo> findAll(String address, Predicate<Utxo> predicate, Set<Utxo> excludeUtxos) throws ApiException {
        return this.utxoSelector.findAll(address, predicate, this.getFinalExcludeList(excludeUtxos));
    }

    private Set<Utxo> getFinalExcludeList(Set<Utxo> excludeUtxos) {
        Set<Utxo> finalUtxoToExclude;
        if (excludeUtxos != null && !excludeUtxos.isEmpty()) {
            finalUtxoToExclude = new HashSet<Utxo>(excludeUtxos);
            finalUtxoToExclude.addAll(this.excludeList);
        } else {
            finalUtxoToExclude = this.excludeList;
        }
        return finalUtxoToExclude;
    }
}

