/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.coinselection.impl;

import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.api.exception.InsufficientBalanceException;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.coinselection.UtxoSelectionStrategy;
import com.bloxbean.cardano.client.coinselection.exception.InputsLimitExceededException;
import com.bloxbean.cardano.client.coinselection.impl.LargestFirstUtxoSelectionStrategy;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultUtxoSelectionStrategyImpl
implements UtxoSelectionStrategy {
    private final UtxoSupplier utxoSupplier;
    private boolean ignoreUtxosWithDatumHash;

    public DefaultUtxoSelectionStrategyImpl(UtxoSupplier utxoSupplier) {
        this(utxoSupplier, true);
    }

    public DefaultUtxoSelectionStrategyImpl(UtxoSupplier utxoSupplier, boolean ignoreUtxosWithDatumHash) {
        this.utxoSupplier = utxoSupplier;
        this.ignoreUtxosWithDatumHash = ignoreUtxosWithDatumHash;
    }

    @Override
    public Set<Utxo> select(String sender, List<Amount> outputAmounts, String datumHash, PlutusData inlineDatum, Set<Utxo> utxosToExclude, int maxUtxoSelectionLimit) {
        if (outputAmounts == null || outputAmounts.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            HashSet<Utxo> selectedUtxos = new HashSet<Utxo>();
            Map<String, BigInteger> remaining = new HashMap<String, BigInteger>(outputAmounts.stream().collect(Collectors.groupingBy(Amount::getUnit, Collectors.reducing(BigInteger.ZERO, Amount::getQuantity, BigInteger::add)))).entrySet().stream().filter(entry -> BigInteger.ZERO.compareTo((BigInteger)entry.getValue()) < 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            int page = 0;
            int nrOfItems = 100;
            while (!remaining.isEmpty()) {
                List fetchResult = this.utxoSupplier.getPage(sender, Integer.valueOf(100), Integer.valueOf(page), OrderEnum.asc);
                List<Utxo> fetched = fetchResult != null ? fetchResult.stream().sorted(DefaultUtxoSelectionStrategyImpl.sortByMostMatchingAssets(outputAmounts)).collect(Collectors.toList()) : Collections.emptyList();
                ++page;
                for (Utxo utxo : fetched) {
                    if (!this.accept(utxo) || utxosToExclude != null && utxosToExclude.contains(utxo) || utxo.getDataHash() != null && !utxo.getDataHash().isEmpty() && this.ignoreUtxosWithDatumHash || datumHash != null && !datumHash.isEmpty() && !datumHash.equals(utxo.getDataHash()) || inlineDatum != null && !inlineDatum.serializeToHex().equals(utxo.getInlineDatum()) || selectedUtxos.contains(utxo)) continue;
                    List utxoAmounts = utxo.getAmount();
                    boolean utxoSelected = false;
                    for (Amount amount : utxoAmounts) {
                        BigInteger remainingAmount = remaining.get(amount.getUnit());
                        if (remainingAmount == null || BigInteger.ZERO.compareTo(remainingAmount) >= 0) continue;
                        utxoSelected = true;
                        BigInteger newRemaining = remainingAmount.subtract(amount.getQuantity());
                        if (BigInteger.ZERO.compareTo(newRemaining) < 0) {
                            remaining.put(amount.getUnit(), newRemaining);
                            continue;
                        }
                        remaining.remove(amount.getUnit());
                    }
                    if (!utxoSelected) continue;
                    selectedUtxos.add(utxo);
                    if (remaining.isEmpty() || selectedUtxos.size() <= maxUtxoSelectionLimit) continue;
                    throw new InputsLimitExceededException("Selection limit of " + maxUtxoSelectionLimit + " utxos reached with " + remaining + " remaining");
                }
                if (!fetched.isEmpty()) continue;
                break;
            }
            if (!remaining.isEmpty()) {
                throw new InsufficientBalanceException("Not enough funds for [" + remaining + "], address: " + sender);
            }
            return selectedUtxos;
        }
        catch (InputsLimitExceededException e) {
            UtxoSelectionStrategy fallback = this.fallback();
            if (fallback != null) {
                return fallback.select(sender, outputAmounts, datumHash, inlineDatum, utxosToExclude, maxUtxoSelectionLimit);
            }
            throw new ApiRuntimeException("Input limit exceeded and no fallback provided", (Exception)e);
        }
    }

    private static Comparator<Utxo> sortByMostMatchingAssets(List<Amount> outputAmounts) {
        return (o1, o2) -> Integer.compare(DefaultUtxoSelectionStrategyImpl.countMatchingAssets(o2.getAmount(), outputAmounts), DefaultUtxoSelectionStrategyImpl.countMatchingAssets(o1.getAmount(), outputAmounts));
    }

    private static int countMatchingAssets(List<Amount> l1, List<Amount> outputAmounts) {
        if (l1 == null || l1.isEmpty() || outputAmounts == null || outputAmounts.isEmpty()) {
            return 0;
        }
        return (int)l1.stream().filter(it1 -> outputAmounts.stream().filter(outputAmount -> it1.getUnit() != null && it1.getUnit().equals(outputAmount.getUnit())).findFirst().isPresent()).map(it -> 1).count();
    }

    @Override
    public UtxoSelectionStrategy fallback() {
        return new LargestFirstUtxoSelectionStrategy(this.utxoSupplier, this.ignoreUtxosWithDatumHash);
    }

    protected boolean accept(Utxo utxo) {
        return true;
    }

    @Override
    public void setIgnoreUtxosWithDatumHash(boolean ignoreUtxosWithDatumHash) {
        this.ignoreUtxosWithDatumHash = ignoreUtxosWithDatumHash;
    }
}

